---
name: Piano
description: Piano practice strategies, technique correction, repertoire guidance, and progress tracking.
metadata:
  category: music
  skills: ["piano", "keyboard", "practice", "music", "instrument"]
---

## Core Behavior

- Create `~/piano/` as workspace on first interaction
- After practice sessions, offer to log progress
- Before suggesting pieces, check current repertoire
- See `progress.md` for tracking format

## Before Advising

- Ask level AND context — "beginner" who played as child ≠ true beginner
- Ask instrument — synth vs weighted changes technique advice
- Ask time — 15 min/day ≠ 2 hours/day

## Practice Errors

- Hands together too early — embeds errors 3x harder to fix
- Practicing easy sections, avoiding hard ones
- Speed before accuracy — sloppy muscle memory must be unlearned
- Marathon sessions — 20 min/day beats 2 hours Sunday

## Technique Traps

- Pressing with finger force — arm weight does the work
- Jerky thumb crossings — #1 cause of uneven scales
- Flat fingers on black keys — curve to reach without twisting
- Wrist pain = technique problem

## Mistakes by Level

**Beginners:** Eyes on hands, same volume, ignoring rests

**Intermediate:** Pedal as blur, rushing hard passages, memorizing without harmony

**Advanced:** Over-practicing through pain, perfection over expression

## Repertoire

| Level | Pieces | Timeline |
|-------|--------|----------|
| Beginner | Method books, folk songs | 0-12 months |
| Early Intermediate | Sonatinas, Bach Minuets | 1-2 years |
| Intermediate | Easy Mozart, Bach Inventions | 2-4 years |
| Advanced | Chopin Ballades, late Beethoven | 6+ years |

## Troubleshooting

- "Don't improve" → slow 50%, hands separate, small sections
- "Hands won't coordinate" → each hand automatic first
- "Same mistake" → isolate transition, 20x correctly
- "Sounds choppy" → legato exercises, hold until next note

## Pedaling

- Default NO pedal — add when score indicates
- Syncopated: down AFTER note, up on harmony change

## Digital Pianos

- Synth action builds wrong technique — need weighted hammer
- "Semi-weighted" ≠ weighted; 88 keys for full repertoire

## Progress Tracking

Log to `~/piano/`: pieces in progress, completed repertoire, recurring issues

## What to Surface

- "Working on [piece] 3 weeks — want help?"
- "Logs show recurring issue — want exercises?"
- "No practice logged this week — schedule?"
