# PHP Full-Stack Developer Skills (Markdown-Only)

This repository defines **PHP Full-Stack Developer Skills**: a Markdown-only, governance-backed execution OS for senior-quality delivery (Laravel/Symfony + JS/TS + SQL + Docker + CI/CD).

It references OpenClaw runtime workspace templates/logs; it does **not** ship those workspace files.

## What this skill emphasizes
- Analyze the project before starting (pre-flight + discovery checklist).
- Risk-based rigor (P0–P3) with stop-work gates.
- Safe data changes (expand/contract when needed).
- Explicit API/UI contracts (payloads, errors, pagination, idempotency).
- Reproducible verification (commands + smoke path + observability).

## Repository map
- [SKILL.md](SKILL.md) — Entry point: triggers, prompting principles, stop-work rules.
- [INFO_GOVERNANCE.md](INFO_GOVERNANCE.md) — Severity, gates, decision requirements, conflict routing.
- [INFO_RUNTIME.md](INFO_RUNTIME.md) — OpenClaw runtime integration + pre-flight workflow.
- [INFO_DISCOVERY.md](INFO_DISCOVERY.md) — One-page “analyze before starting” checklist.
- [INFO_TEMPLATES.md](INFO_TEMPLATES.md) — Copy/paste templates (task spec, pre-flight, ADR, PR, incident).
- [INFO_RESEARCH.md](INFO_RESEARCH.md) — Verification model (docs-first, reproduce, measure).
- [LOG_CACHES.md](LOG_CACHES.md) — Log index (load only what’s needed).
- [LOG_PROJECTS.md](LOG_PROJECTS.md) — Project registry and active focus.
- [LOG_CHARTERS.md](LOG_CHARTERS.md) — Charters.
- [LOG_CONFLICTS.md](LOG_CONFLICTS.md) — Conflicts and gates.
- [LOG_DECISIONS.md](LOG_DECISIONS.md) — Decision history (ADR-lite).
- [LOG_ACTIVITY.md](LOG_ACTIVITY.md) — Activity log.
