# Runtime Integration (OpenClaw Workspace)

This document instructs OpenClaw how to interact with its runtime workspace templates and memory files.
This skill references runtime workspace templates; it does not contain them.
Codex authors this skill; OpenClaw executes it at runtime.

## A) Boot Read Order (OpenClaw Action List)
On boot, open these workspace files and read in this order (note: `MEMORY.md` is a single Markdown file in the workspace):
1. `~/.openclaw/workspace/SOUL.md`
2. `~/.openclaw/workspace/USER.md`
3. `~/.openclaw/workspace/memory/YYYY-MM-DD.md` (today + yesterday)
4. If in MAIN SESSION, also read `~/.openclaw/workspace/MEMORY.md`

Then load skill cache files:
- `LOG_CACHES.md` (index only)
- Load only the specific log file needed: `LOG_PROJECTS.md`, `LOG_CHARTERS.md`, `LOG_CONFLICTS.md`, `LOG_DECISIONS.md`, `LOG_ACTIVITY.md`

## B) Mandatory start: Pre-Flight (analyze before starting)
Before implementation, produce a Pre-Flight Summary (template in `INFO_TEMPLATES.md`) and either:
- attach it to the task spec, or
- log it as an Activity entry (Type=Pre-Flight)

If Pre-Flight discovers unknowns affecting security/data/contracts for P1+, log a conflict and stop.

### Pre-Flight Steps
1) Context scan (domain, critical flows, deploy shape, runtime versions)
2) Risk classification (P0–P3)
3) Constraints + invariants + non-goals
4) Contract check (consumers, payloads, errors, pagination, idempotency)
5) Data safety plan (migration strategy + rollback)
6) Verification plan (commands + smoke path + observability)

### Quick Risk Score (0–10)
+3 auth/authz change
+3 schema/backfill
+2 external integration/webhook
+1 performance-sensitive path
+1 deploy/CI/runtime change
+1 unclear requirements

0–2: P3, 3–4: P2, 5–7: P1, 8–10: P0
If score >=5, require explicit rollout + rollback notes.

## C) Execution rules
- Prefer reversible steps and staged rollout for P1+.
- Always include “How to test” commands.
- For schema changes: prefer expand/contract when large tables or tight SLAs exist.

## D) Write targets
- Work performed: `LOG_ACTIVITY.md`
- Decisions: `LOG_DECISIONS.md`
- Conflicts: `LOG_CONFLICTS.md`
- Verified facts (versions/endpoints/constraints): `LOG_CACHES.md`
