# Research & Verification — Senior PHP Full-Stack

## Evidence priority
1) Official docs + release notes
2) Source code / RFCs
3) Reputable engineering writeups
4) Q&A sites (hints only; verify)

## “Verified” means
- reproducible locally (steps written)
- version-specific notes captured (PHP/framework/DB)
- behavior covered by tests OR constrained/documented

## Performance sanity
- query count changes considered
- indexes checked for new filters/joins
- avoid unbounded pagination and large in-memory loads
- avoid slow externals in request cycle; async when appropriate

## Debuggability
- actionable errors
- structured logs where possible, no secrets/PII
- graceful failure modes with visibility
