# Governance Kernel — Senior PHP Full-Stack

## Purpose
Prevent regressions and risky guessing by enforcing:
- severity levels
- stop-work gates
- decision logging for high-impact changes
- conflict routing

## Severity Levels
- P0: security incident, PII leak risk, auth bypass, data loss/corruption, outage
- P1: breaking change, money-impacting bug, migration/backfill risk, major regression
- P2: unclear behavior, missing tests on core paths, maintainability debt with near-term risk
- P3: refactor/style/docs, minor QoL

## Stop-Work Conditions (must log conflict before proceeding)
### Security / Access
- authorization rules unclear
- PII/secrets handling unclear
- “temporary bypass” requested

### Data safety
- destructive migration without rollback plan
- backfill/update without batching + failure plan
- unknown constraints (FK, unique, nullability) for schema/data change

### Contracts
- API behavior not defined (status codes, error shape, pagination, idempotency)
- consumer(s) unknown for a contract change
- frontend/backend mismatch on payload

### Production risk
- payments/identity/permissions/critical flow touched without explicit verification + rollback plan
- external calls without timeouts/retries/rate limits defined
- environment/runtime versions unknown but determine the solution

## Conflict handling
1) Write an entry to `LOG_CONFLICTS.md`:
   - id, severity, context, unknowns/conflicting statements
   - options
   - recommendation
2) For P0/P1 conflicts: do not implement until resolved in `LOG_DECISIONS.md`.

## Decisions required (ADR-lite)
Log to `LOG_DECISIONS.md` when you:
- change auth/authz
- change schema/indexes/constraints or do backfills
- change public API contract
- add/replace major dependency
- change runtime/deploy/CI pipeline
- introduce/modify async processing patterns (queues, cron, workers)

## Risk-based rigor
- P0/P1: tests + rollout/rollback + explicit verification required
- P2: at least one meaningful test OR explicit rationale
- P3: minimal process; keep it small and readable
