# Project Discovery Checklist — PHP Full-Stack (Senior)

Purpose: minimal facts to avoid bad assumptions before coding.
Use when starting a new project or inheriting an existing codebase.

## 1) System shape
- App type: Laravel / Symfony / custom
- Architecture: monolith / API+SPA / multi-service
- Entry points: web, CLI, queue workers, cron/scheduler, webhooks
- Critical flows: auth, permissions, payments, emails, imports, UGC, PII

Stop-work: if changing a critical flow you can’t name.

## 2) Runtime & versions (facts, not guesses)
Record to `LOG_CACHES.md` when relevant:
- PHP version, framework version, Composer constraints, required extensions
- Node/Vite version (frontend)
- DB engine/version
- Cache + queue driver
- Mail/storage providers

Stop-work: unknown PHP/framework/DB version for P1+ tasks.

## 3) Repo health
- composer scripts, lockfile committed
- risky/abandoned deps noted
- PSR-4 sane, config strategy understood

## 4) Can we run it locally?
- Docker compose or clear local setup
- one-command boot (or define it)
- seed/fixtures
- smoke route / API ping

Stop-work: can’t run tests locally for P1+.

## 5) Quality gates
- PHPUnit/Pest, static analysis (PHPStan/Psalm), formatters, CI present
- If no tests: add a minimal “safety net” test for the change.

## 6) Conventions
Laravel: middleware, policies/gates, Form Requests, service/actions
Symfony: services, validation, voters/roles, Messenger

Stop-work: authz mechanism unclear.

## 7) Data model & migrations
- FKs, uniques, nullability, hot tables
- backfill strategy history
- replicas/locks concerns

Stop-work: destructive migration without rollback.

## 8) Contracts & clients
- consumers, versioning, error format, pagination, idempotency, auth method

Stop-work: consumers unknown for contract changes.

## 9) Observability
- logs destination, error tracking, metrics/tracing, correlation IDs
- queue monitoring, feature flags

## 10) Security baseline
- CSRF, escaping, uploads, secrets mgmt, webhook signature verification

## Output
Produce Pre-Flight Summary + log unknowns as conflicts if P1+.
