---
name: Photography
description: Camera settings, composition, lighting, editing workflow, and genre-specific techniques.
metadata:
  category: creative
  skills: ["photography", "camera", "lighting", "editing", "composition"]
---

## Exposure Triangle

- ISO: double ISO = double brightness, but also double noise. Stay lowest possible
- Aperture: f/2.8 = shallow depth of field (blurry background), f/11 = everything sharp
- Shutter: 1/focal length minimum for handheld — 50mm lens needs 1/50s or faster
- Expose for highlights — blown highlights unrecoverable, shadows can be lifted in post

## Focus Fundamentals

- Focus on eyes for portraits — always the nearest eye
- Back-button focus separates focus from shutter — press once to lock, recompose freely
- Single-point AF for precision, tracking AF for movement
- Hyperfocal distance for landscapes: focus 1/3 into scene, everything sharp at f/8-11
- When in doubt, stop down — f/8 is sharper than wide open for most lenses

## Composition Beyond Rule of Thirds

- Leading lines pull eyes into frame — roads, fences, rivers toward subject
- Frame within frame: doorways, windows, arches add depth
- Negative space: empty area emphasizes subject — don't fill every corner
- Odd numbers: 3 or 5 subjects more pleasing than 2 or 4
- Break rules intentionally: centered subject with symmetry works

## Natural Light

- Golden hour: 1 hour after sunrise, 1 hour before sunset — warm, soft, directional
- Blue hour: 20-30 minutes after sunset — even, moody, no harsh shadows
- Overcast is giant softbox — ideal for portraits, no squinting
- Midday sun: use as backlight or find open shade — avoid direct overhead
- Window light: subject facing window, not camera — soft directional light

## Flash Basics

- Bounce off ceiling/wall — direct flash is harsh and flat
- Flash exposure compensation: start at -1 to -2 stops — blend with ambient
- High-speed sync for daylight fill — allows wide aperture outdoors
- Off-camera flash: 45 degrees from subject, elevated — creates dimension
- Catch light in eyes: small light source close beats large source far

## Common Mistakes

- Horizon not level — first thing viewers notice is wrong
- Cutting at joints: ankles, wrists, knees — crop mid-limb or full body
- Busy backgrounds: poles from heads, distracting elements
- Chimping constantly — looking at screen after every shot instead of moments
- Not checking histogram — LCD brightness deceives, histogram doesn't lie

## Camera Settings by Genre

**Portraits:**
- Aperture priority, f/1.8-2.8
- Single-point AF on eye
- +1/3 exposure for skin brightness

**Landscapes:**
- Aperture priority, f/8-11
- Tripod, mirror lock, remote/timer
- Bracket exposures for HDR

**Sports/Action:**
- Shutter priority, 1/500s minimum
- Continuous AF tracking
- Burst mode, anticipate peak action

**Street:**
- Aperture priority, f/5.6-8
- Zone focus preset at 3m
- Shoot from hip if needed

## RAW vs JPEG

- Shoot RAW for editing flexibility — recovers 2-3 stops of exposure
- JPEG for volume without editing — events with hundreds of shots
- RAW + JPEG: preview immediately, edit RAW later
- RAW files need processing — they look flat by design, not a problem

## Editing Workflow

1. Cull ruthlessly: delete obvious failures first
2. Global adjustments: exposure, white balance, contrast
3. Local adjustments: dodge/burn, graduated filters
4. Color grading: consistent look across set
5. Export: sRGB for web, AdobeRGB for print

- Edit on calibrated monitor — laptop screens lie about color
- Sharpening last, after resize — oversharpening destroys detail
- Less is more: if you notice the edit, you went too far

## Gear Reality

- Best camera is the one you have — phone beats DSLR at home
- Lenses matter more than bodies — invest in glass first
- 50mm f/1.8 is best first prime — cheap, sharp, teaches composition
- Tripod: don't cheap out — flimsy tripod is worse than none
- One good light > three bad ones — start with single source

## File Management

- Backup same day: 3-2-1 rule (3 copies, 2 media types, 1 offsite)
- Folder structure: YYYY/YYYY-MM-DD_EventName
- Rename files: YYYYMMDD_ProjectName_0001.ext
- Keywords and ratings during import — not later when you forget context
- Archive RAW files forever, even rejected ones — storage is cheap, moments aren't
