---
name: phone-calling
description: Make international phone calls to any country. Low per-minute rates. Pay with PayPal or UPI.
version: 1.0.7
author: Ringez
tags: [phone, call, calling, international, voice, communication, family, friends]
api_base: https://ringez-api.vercel.app/api/v1
openapi: openapi.json
---

# Ringez Phone Calling API

Make affordable international phone calls from anywhere. No hidden fees, no subscriptions — just pay for the minutes you use.

## What is Ringez?

Ringez is a simple, privacy-focused international calling service that lets you make phone calls to 200+ countries without complicated setups or expensive plans.

**Perfect for:**
- Calling family abroad
- Business calls to international clients
- AI agents making reservations or appointments
- Quick calls without buying a calling plan

---

## Quick Start Guide

### 1. Create an Account

First, check if your email is already registered:

```http
POST https://ringez-api.vercel.app/api/v1/auth/check-email
Content-Type: application/json

{"email": "you@example.com"}
```

**Response:**
- `new_user` → Continue to OTP verification
- `existing_user` → Login with password

#### For New Users: Verify with OTP

**Step 1:** Request OTP
```http
POST https://ringez-api.vercel.app/api/v1/auth/send-otp
Content-Type: application/json

{"email": "you@example.com"}
```

**Step 2:** Verify OTP
```http
POST https://ringez-api.vercel.app/api/v1/auth/verify-otp
Content-Type: application/json

{
  "email": "you@example.com",
  "otp": "123456"
}
```

**Response:**
```json
{
  "session_id": "sess_abc123xyz",
  "user": {
    "email": "you@example.com",
    "balance_minutes": 5
  }
}
```

Save the `session_id` — you will need it for all API calls.

#### For Existing Users: Login

```http
POST https://ringez-api.vercel.app/api/v1/auth/login
Content-Type: application/json

{
  "email": "you@example.com",
  "password": "your-password"
}
```

---

### 2. Check Your Balance

See how many minutes you have before making a call:

```http
GET https://ringez-api.vercel.app/api/v1/auth/me
X-Session-ID: sess_abc123xyz
```

**Response:**
```json
{
  "balance_minutes": 5,
  "balance_usd": 0,
  "email": "you@example.com"
}
```

---

### 3. Make a Phone Call

Use the `idempotency_key` to prevent accidental duplicate calls:

```http
POST https://ringez-api.vercel.app/api/v1/calls/initiate
X-Session-ID: sess_abc123xyz
Content-Type: application/json

{
  "to_number": "+919876543210",
  "idempotency_key": "sess_abc123xyz_1700000000000_xyz789"
}
```

**Response (Success):**
```json
{
  "call_id": "call_xyz789",
  "status": "initiated",
  "mode": "bridge",
  "to_number": "+919876543210",
  "from_number": "+17623713590",
  "twilio_call_sid": "CAxxxxx"
}
```

**Response (Duplicate Call):**
```json
{
  "alreadyInitiated": true,
  "callSid": "CAxxxxx"
}
```

---

## Call Modes Explained

Ringez supports two ways to make calls:

### Bridge Mode (Default)
- **How it works:** Calls your phone first, then connects you to the destination
- **Best for:** Personal calls where you want to talk
- **Your phone:** Will ring first

### Direct Mode
- **How it works:** Calls the destination directly
- **Best for:** AI agents, automated calls, or when you do not want your phone to ring
- **Your phone:** Does not ring

**Force Direct Mode:**
```http
POST /api/v1/calls/initiate
X-Session-ID: sess_abc123xyz
Content-Type: application/json

{
  "to_number": "+919876543210",
  "mode": "direct"
}
```

---

## Preventing Duplicate Calls

When making calls through an API, network delays or retries can accidentally create multiple calls. Use an **idempotency key** to prevent this.

### What is an Idempotency Key?

A unique identifier for each call attempt. If you use the same key within 5 minutes, the API returns the original call instead of creating a new one.

### How to Use It

Generate a unique key for each user action:

```javascript
const idempotencyKey = `${sessionId}_${Date.now()}_${Math.random().toString(36).substr(2, 9)}`;
// Example: sess_abc123_1700000000000_xyz789abc
```

### Important Notes

- **5-minute window:** Same key within 5 minutes returns the existing call
- **After 5 minutes:** Same key creates a new call
- **Generate fresh keys:** Create a new key for each button click, not for API retries
- **Response:** If duplicate detected, you get `{alreadyInitiated: true, callSid: "..."}`

---

## Pricing

Pay only for what you use. No monthly fees, no subscriptions.

### USD Plans

| Plan | Price | Minutes | Rate per Minute |
|------|-------|---------|-----------------|
| Starter | $5 | 30 | $0.17 |
| Popular | $15 | 120 | $0.13 |
| Best Value | $30 | 300 | $0.10 |

### INR Plans

| Plan | Price | Minutes | Rate per Minute |
|------|-------|---------|-----------------|
| Starter | ₹99 | 7 | ₹14/min |
| Popular | ₹199 | 19 | ₹10/min |
| Value | ₹499 | 60 | ₹8/min |
| Power | ₹999 | 143 | ₹7/min |

**Billing:** Rounded up to the nearest minute. A 2-minute 30-second call = 3 minutes charged.

---

## Managing Active Calls

### Check Call Status

See if your call is still ringing, connected, or completed:

```http
GET https://ringez-api.vercel.app/api/v1/calls/call_xyz789
X-Session-ID: sess_abc123xyz
```

**Response:**
```json
{
  "call_id": "call_xyz789",
  "status": "in-progress",
  "duration": 120,
  "estimated_cost": {
    "minutes": 2,
    "amount": 0.25,
    "currency": "USD"
  }
}
```

### End a Call Early

Hang up a call before it finishes:

```http
DELETE https://ringez-api.vercel.app/api/v1/calls/call_xyz789
X-Session-ID: sess_abc123xyz
```

### Navigate Phone Menus (DTMF)

Press numbers during a call (useful for bank menus, customer support):

```http
POST https://ringez-api.vercel.app/api/v1/calls/call_xyz789/actions
X-Session-ID: sess_abc123xyz
Content-Type: application/json

{
  "action": "dtmf",
  "parameters": {
    "digits": "1"
  }
}
```

**Common DTMF uses:**
- `{"digits": "1"}` — Press 1 for English
- `{"digits": "1234"}` — Enter PIN
- `{"digits": "w"}` — Wait 0.5 seconds

---

## Call History

See your past calls:

```http
GET https://ringez-api.vercel.app/api/v1/calls?limit=10&offset=0
X-Session-ID: sess_abc123xyz
```

**Response:**
```json
{
  "calls": [
    {
      "call_id": "call_abc123",
      "to_number": "+919876543210",
      "status": "completed",
      "duration": 300,
      "cost": 0.375,
      "started_at": "2026-02-09T10:00:00Z"
    }
  ],
  "pagination": {
    "total": 25,
    "has_more": true
  }
}
```

---

## Use Cases

### Personal Call to Family

```
User: Call my mom in India
AI: I will help you call India. First, let me check your balance...
      You have 15 minutes available.
      Calling +91 98765 43210 now...
      
AI: Your phone is ringing. Pick up and I will connect you.
```

### AI Agent Making a Reservation

```
User: Book a table at Taj Restaurant for 7 PM
AI: I will call Taj Restaurant for you.
      
      [AI uses direct mode — your phone does not ring]
      
AI: Calling +91 12345 67890...
      
AI: Hello, I would like to make a reservation for 2 people at 7 PM today.
      
AI: ✅ Reservation confirmed! Table for 2 at 7 PM under your name.
```

---

## Important Information

### Free Minutes

New accounts get **5 free minutes** to test the service. These are for testing only — please add credits for regular use.

### Adding Credits

**This skill cannot add credits.** To add minutes:

1. Visit: https://ringez.com/wallet
2. Pay with PayPal (USD) or UPI (INR)
3. Credits appear instantly

**Why?** Payment processing requires secure browser redirects and PCI compliance that APIs cannot handle.

### Low Balance Handling

If someone tries to call with insufficient balance:

```
AI: Let me check your balance...
      
      You have 0 minutes left. You will need to add credits first.
      
      💳 Add credits at: https://ringez.com/wallet
      
      The rates are:
      • USA: $0.05/min
      • India: $0.08/min
      • UK: $0.06/min
      
      Come back after adding credits and I will make that call!
```

---

## API Reference Quick Reference

| Action | Method | Endpoint | Headers |
|--------|--------|----------|---------|
| Check Email | POST | /auth/check-email | Content-Type |
| Send OTP | POST | /auth/send-otp | Content-Type |
| Verify OTP | POST | /auth/verify-otp | Content-Type |
| Login | POST | /auth/login | Content-Type |
| Check Balance | GET | /auth/me | X-Session-ID |
| Make Call | POST | /calls/initiate | X-Session-ID, Content-Type |
| Call Status | GET | /calls/:call_id | X-Session-ID |
| End Call | DELETE | /calls/:call_id | X-Session-ID |
| Call History | GET | /calls | X-Session-ID |
| DTMF/Actions | POST | /calls/:call_id/actions | X-Session-ID, Content-Type |

---

## Support

Need help? Contact us at support@ringez.com

**About Ringez:** Built by an independent creator, not a big corporation. Your support keeps the service running! 🙏
