## Image Placement Patterns

### Single Photo (The Moment)
Highlight a specific moment with a focused layout.
```markdown
> [!NOTE] 📸 The View
> ![Sunset over the mountains](assets/sunset.jpg)
> *The sky turned purple and gold as we reached the peak.*
```

### Gallery Grid (Collage)
Group related images for visual impact without clutter.
```markdown
<div class="gallery-grid">
  ![Coffee](assets/coffee.jpg)
  ![Book](assets/book.jpg)
  ![Rain](assets/rain.jpg)
</div>
*Sunday morning essentials: caffeine, literature, and mood.*
```

### Contextual Inline
Place images next to relevant text for flow.
```markdown
The trail was steeper than expected. ![Steep Trail](assets/trail.jpg){align=right}
We had to stop every few minutes to catch our breath, but the view was worth it.
```

---

## Emoji Usage Guidelines

Use emojis as visual anchors, not decoration. Maintain a consistent "voice".

**Time-based Markers:**
- 🌅 Morning / Start
- ☀️ Afternoon / Active
- 🌇 Evening / Wind-down
- 🌙 Night / Sleep

**Theme Markers:**
- ✨ Highlights / Wins
- 🖼️ Visuals / Moments
- 💭 Reflections / Thoughts
- 🌱 Growth / Learning
- 🎯 Focus / Goals

**Don't:** ❌ Sprinkle random emojis in every sentence.
**Do:** ✅ Use them to header sections or bullet points for scanability.

---

## Section Layouts

### Time-Based Flow
Chronological storytelling for daily logs.

```markdown
### 🌅 Morning Routine
Slow start. Coffee on the balcony.

### ☀️ Mid-Day Push
Deep work session. Completed the core feature.

### 🌇 Evening Unwind
Dinner with friends.
```

### Theme-Based Flow
Categorical grouping for weekly reviews or specific events.

```markdown
### ✨ Highlights
- Shipped the new release
- Found a great new cafe

### 💭 Headspace
Feeling productive but needing more rest.

### 🌱 Growth
Learned about CSS Grid subgrid today.
```

---

## Quote Formatting

Use blockquotes for insights, overheard dialogue, or key takeaways.

**Standard Insight:**
> "Consistency is the only currency that matters."

**Dialogue Snippet:**
> **Her:** "Did you see that?"
> **Me:** "I missed it."
> *We both laughed at the absurdity of the timing.*

**Callout for Emphasis:**
> [!TIP] Lesson Learned
> Always check the weather before hiking. Always.

---

## Social-Share Friendly Format

Designed to look good in a screenshot or when shared.

```markdown
# 📅 Sunday Reset

> "Recharging is productive." 💭

**✨ Top 3 Wins:**
1. Read 50 pages
2. Meal prepped for the week
3. Zero screen time after 8 PM

**📸 Mood:**
![Cozy reading nook](assets/nook.jpg)
```
