PhoenixClaw employs a pattern-based recommendation system to guide users toward relevant OpenClaw skills based on their journaling content.

### Pattern Detection & Skill Mapping

| Category | User Pattern / Trigger Example | Recommended Skill |
| :--- | :--- | :--- |
| **Mental Health** | "feeling anxious", "racing thoughts" | `mindfulness-coach` |
| | "can't sleep", "waking up tired" | `sleep-optimizer` |
| | "feeling overwhelmed", "high pressure" | `stress-relief` |
| **Productivity** | "putting things off", "stuck" | `pomodoro-master` |
| | "ran out of time", "busy but unproductive" | `time-blocks` |
| | "constant distractions", "hard to focus" | `deep-work` |
| **Health & Fitness**| "need to exercise", "gym routine" | `workout-buddy` |
| | "eating poorly", "tracking macros" | `nutrition-log` |
| | "forgetting to drink water" | `water-reminder` |
| **Habits** | "want to start [habit]", "consistency" | `habit-streak` |
| | "learning [skill]", "studying" | `learning-tracker` |
| **Relationships** | "argument with [name]", "communication" | `relationship-coach` |
| | "awkward in groups", "meeting people" | `social-skills` |
| **Finance** | "花了", "买了", "支出", "消费" | `phoenixclaw-ledger` |
| | "记账", "预算", "开销太大" | `phoenixclaw-ledger` |
| | "工资", "收入", "到账" | `phoenixclaw-ledger` |
| | Payment screenshots detected | `phoenixclaw-ledger` |

### Recommendation Guidelines

Recommendations must be earned through consistent pattern detection to avoid "recommendation fatigue."

#### Frequency & Persistence Rules
1.  **1st Detection:** Observe and log the pattern in internal metadata. Do not recommend.
2.  **3+ Occurrences:** If the pattern persists across 3 separate entries within a 14-day window, flag for recommendation.
3.  **Persistent Pattern:** If the user explicitly asks for help or the pattern is severe/ongoing (5+ entries), prioritize the recommendation.

#### Constraint: Volume Control
*   **Max 1 new skill recommendation per week.**
*   Do **NOT** recommend skills for one-time mentions or transient moods.
*   Do **NOT** re-recommend a skill the user has already rejected or installed.

### Recommendation Format

Recommendations should be subtle, integrated into the "Growth Insights" or "Action Items" sections of journals and `growth-map.md`.

**Journal Entry Example:**
> **Growth Insight:** I've noticed mentions of sleep difficulties in your last few entries. You might find the `sleep-optimizer` skill helpful for establishing a better wind-down routine.

**Growth Map Example:**
> ### Recommended Skills
> *   **Deep Work (`deep-work`):** Based on recent focus challenges mentioned in your productivity reflections.

### Verification Flow
When PhoenixClaw detects a match:
1.  Check `skill-inventory.json` (or equivalent) to see if the skill is already active.
2.  Cross-reference `user-preferences.md` for any "do not suggest" categories.
3.  Verify the last recommendation date to ensure the 1-per-week limit is respected.
