# Real-time Financial Query Patterns

This document defines the query patterns and response templates for real-time financial inquiries supported by PhoenixClaw Ledger.

## Architecture Note

**Query parsing is an agent-level behavior.** The Ledger plugin provides the underlying data and logic for extraction, but the natural language understanding (NLU) required to map user questions to these patterns is handled by the OpenClaw agent. This document serves as a reference for the agent on how to interpret user intent and how to format the responses.

---

## 1. Time Range Queries (`time_range`)

Queries about total spending or income over a specific period (day, week, month, year).

### Patterns
| Language | Examples |
|----------|----------|
| **Chinese** | "今天花了多少", "这周支出了多少", "本月花费", "最近三天的开销" |
| **English** | "How much did I spend today?", "Total expenses this week", "Monthly spend so far", "Expenses for the last 3 days" |

### Response Template
```markdown
> [!summary] 💰 {{period_label}} Spending
> Total: **{{currency}}{{total_amount}}**
> Breakdown:
> - {{#each categories}}- {{name}}: {{currency}}{{amount}} ({{percent}}%){{/each}}
```

---

## 2. Category Queries (`category`)

Queries focused on specific spending categories (e.g., Food, Transport, Shopping).

### Patterns
| Language | Examples |
|----------|----------|
| **Chinese** | "在咖啡上花了多少", "餐饮支出是多少", "这个月打车花了多少", "购物开支" |
| **English** | "How much did I spend on coffee?", "Total for dining out", "Transport expenses this month", "Shopping spend" |

### Response Template
```markdown
> [!expense] 🏷️ {{category_name}}: {{period_label}}
> Total: **{{currency}}{{total_amount}}**
> Count: {{transaction_count}} transactions
> Recent:
> {{#each transactions}}- {{description}}: {{currency}}{{amount}} ({{date}}){{/each}}
```

---

## 3. Merchant Queries (`merchant`)

Queries about specific merchants or service providers.

### Patterns
| Language | Examples |
|----------|----------|
| **Chinese** | "星巴克消费记录", "最近去麦当劳花了多少", "在亚马逊买了什么" |
| **English** | "Starbucks transactions", "How much at McDonald's recently?", "What did I buy on Amazon?" |

### Response Template
```markdown
> [!receipt] 🛒 Merchant: {{merchant_name}}
> Total spent: **{{currency}}{{total_amount}}**
> Last visit: {{last_visit_date}}
> Transactions:
> {{#each transactions}}- {{date}}: {{currency}}{{amount}} ({{description}}){{/each}}
```

---

## 4. Budget Queries (`budget`)

Queries regarding current budget status and remaining limits.

### Patterns
| Language | Examples |
|----------|----------|
| **Chinese** | "还剩多少预算", "本月超支了吗", "我的预算情况", "预算进度" |
| **English** | "How much budget is left?", "Am I over budget?", "Show my budget status", "Budget progress" |

### Response Template
```markdown
> [!info] 🎯 Budget Status: {{period_label}}
> Used: **{{currency}}{{used_amount}}** / **{{currency}}{{budget_limit}}** ({{percent}}%)
> Remaining: **{{currency}}{{remaining_amount}}**
> {{#if over_budget}}> [!warning] ⚠️ Over budget by {{currency}}{{over_amount}}!{{else}}> Daily allowance: {{currency}}{{daily_allowance}} remaining{{/if}}
```

---

## 5. Comparison Queries (`comparison`)

Queries comparing spending between two periods or categories.

### Patterns
| Language | Examples |
|----------|----------|
| **Chinese** | "上周对比这周", "比起上个月支出如何", "这两次旅游花了多少对比" |
| **English** | "Compare this week to last week", "Spending vs last month", "Comparison between [Period A] and [Period B]" |

### Response Template
```markdown
> [!insight] 📊 Comparison: {{period_a}} vs {{period_b}}
> - {{period_a}}: **{{currency}}{{amount_a}}**
> - {{period_b}}: **{{currency}}{{amount_b}}**
> Difference: **{{diff_prefix}}{{currency}}{{diff_amount}}** ({{diff_percent}}%)
> {{#if decreased}}✨ You spent less than the previous period!{{else}}📈 Spending increased this period.{{/if}}
```

---

## Edge Case Handling

### 1. No Data Found
If no transactions match the query parameters.
- **Pattern**: "I couldn't find any records for [Category/Merchant] in [Period]."
- **Template**: `> [!info] 🔍 No records found for {{query_subject}} during this period.`

### 2. Ambiguous Time Range
If the user says "recently" or "a while ago" without specific dates.
- **Agent Behavior**: Default to "Last 30 days" and state the assumption.
- **Template**: `> [!info] 🕒 Showing records for the last 30 days (default).`

### 3. Unsupported Category
If the user asks for a category that hasn't been mapped yet.
- **Agent Behavior**: Search description fields for keywords and offer to create a new category mapping.
- **Template**: `> [!insight] 💡 I found {{count}} items related to "{{keyword}}", though they aren't in a specific category yet.`

### 4. Budget Not Set
If the user asks about budget but none is configured.
- **Agent Behavior**: Inform the user and provide the command to set one.
- **Template**: `> [!warning] ⚠️ No budget configured. Use "Set my monthly budget to [amount]" to start tracking.`

---
