# Payment Screenshot Recognition

This document defines how PhoenixClaw Ledger extracts transaction data from payment app screenshots.

## Supported Platforms

| Platform | Region | Visual Identifiers |
|----------|--------|-------------------|
| **WeChat Pay** | China | Green checkmark, WeChat logo, "支付成功" |
| **Alipay** | China | Blue interface, Alipay logo, "付款成功" |
| **Apple Pay** | Global | Wallet app UI, card imagery |
| **Google Pay** | Global | Google Pay branding, checkmark |
| **Bank Apps** | Various | Bank logos, transaction confirmations |
| **UnionPay** | China | UnionPay logo, "交易成功" |
| **PayPal** | Global | PayPal logo, confirmation screen |
| **Venmo** | US | Venmo UI, social payment style |

## Detection Workflow

```
Photo Received
      │
      ▼
┌─────────────────────────────────┐
│   Step 1: Screenshot Detection   │
│   Is this a payment screenshot?  │
└─────────────────────────────────┘
      │
      ├── NO  → Standard photo processing (PhoenixClaw Core)
      │
      ▼ YES
┌─────────────────────────────────┐
│   Step 2: Platform Identification│
│   Which payment app/service?     │
└─────────────────────────────────┘
      │
      ▼
┌─────────────────────────────────┐
│   Step 3: Data Extraction        │
│   OCR + Structured parsing       │
└─────────────────────────────────┘
      │
      ▼
┌─────────────────────────────────┐
│   Step 4: Validation             │
│   Confidence check, dedup        │
└─────────────────────────────────┘
      │
      ├── High Confidence → Auto-record
      │
      └── Low Confidence  → Flag for review
```

## Visual Detection Criteria

### WeChat Pay (微信支付)

| Element | Expected |
|---------|----------|
| Color Scheme | Green primary (#07C160) |
| Success Icon | Green checkmark circle |
| Key Text | "支付成功", "已支付", "付款成功" |
| Amount Position | Large, centered, ¥XX.XX format |
| Merchant | Below amount, smaller text |
| Timestamp | "支付时间" + datetime |
| Order ID | "订单号" or "商户单号" |

### Alipay (支付宝)

| Element | Expected |
|---------|----------|
| Color Scheme | Blue primary (#1677FF) |
| Success Icon | Blue checkmark or tick animation |
| Key Text | "付款成功", "交易成功" |
| Amount Position | Large, centered |
| Merchant | Merchant name prominently displayed |
| Payment Method | Card/balance indicator |

### Generic Bank Apps

| Element | Expected |
|---------|----------|
| Bank Logo | Institution branding |
| Transaction Type | "转账成功", "Transfer Complete" |
| Amount | Currency symbol + amount |
| Recipient/Merchant | Account info or name |
| Reference Number | Transaction ID |

## Data Extraction Schema

```yaml
payment_screenshot:
  # Required fields
  platform: wechat|alipay|apple_pay|google_pay|bank|unionpay|paypal|venmo|unknown
  type: expense|income|transfer
  amount: float
  currency: string
  
  # Common fields
  merchant: string           # Merchant/recipient name
  timestamp: ISO8601         # Transaction time from screenshot
  category_hint: string      # AI-inferred category
  
  # Optional fields
  order_id: string           # Order/transaction number
  payment_method: string     # Card, balance, etc.
  original_amount: float     # Pre-discount amount
  discount: float            # Discount/coupon amount
  
  # Metadata
  confidence: float          # 0-1 extraction confidence
  screenshot_path: string    # Path to stored image
  needs_review: boolean      # Flag for low confidence
```

## OCR Best Practices

### Pre-processing

1. **Crop to Content**: Remove status bar, navigation
2. **Enhance Contrast**: Improve text readability
3. **Correct Orientation**: Ensure upright orientation

### Extraction Priority

Extract fields in this order (most reliable first):

1. **Amount**: Usually largest, most prominent text
2. **Platform**: Logo/branding detection
3. **Merchant**: Secondary text near amount
4. **Timestamp**: Standardized format
5. **Other Details**: Payment method, order ID

### Common OCR Challenges

| Challenge | Solution |
|-----------|----------|
| Stylized fonts | Use multiple OCR passes |
| Low resolution | Request higher quality image |
| Partial screenshot | Extract available data, flag incomplete |
| Non-standard layout | Platform-specific parsing rules |

## Confidence Scoring

| Score | Criteria | Action |
|-------|----------|--------|
| **≥0.9** | All key fields extracted, platform identified | Auto-record |
| **0.7-0.9** | Amount + merchant extracted, some uncertainty | Auto-record, flag for review |
| **0.5-0.7** | Partial extraction, likely payment screenshot | Store, ask for confirmation |
| **<0.5** | Uncertain if payment screenshot | Treat as regular photo |

### Confidence Factors

| Factor | Weight | Notes |
|--------|--------|-------|
| Platform identified | +0.2 | Known UI patterns |
| Amount extracted | +0.3 | Most critical field |
| Merchant extracted | +0.2 | Important for categorization |
| Timestamp found | +0.1 | Helps with deduplication |
| Order ID found | +0.1 | Confirms transaction record |
| Success indicator | +0.1 | Confirms completed payment |

## Deduplication

Prevent recording the same transaction multiple times:

### Match Criteria

Two records are considered duplicates if:

```
same_amount AND
same_merchant (fuzzy match) AND
timestamp_diff < 30 minutes
```

### Resolution Strategy

1. **Screenshot Priority**: Screenshot data is more accurate than conversation
2. **Merge Context**: Combine conversation description with screenshot details
3. **Keep Latest**: If multiple screenshots, keep the most detailed one

## Storage

### Screenshot Files

```
~/PhoenixClaw/Journal/assets/YYYY-MM-DD/
├── img_001.jpg           # Regular photos
├── receipt_001.jpg       # Payment screenshots
├── receipt_002.jpg
└── receipt_001.json      # Extracted metadata (optional)
```

### Naming Convention

- Format: `receipt_XXX.{ext}`
- Preserve original extension (jpg, png, heic)
- Zero-padded sequence number
- Optional: `receipt_001_wechat.jpg` for platform suffix

## Privacy Considerations

### Sensitive Data Handling

1. **Mask Account Numbers**: Store only last 4 digits if visible
2. **No Full Names**: Use merchant name, not personal recipient names
3. **Local Storage Only**: Screenshots never uploaded to external services
4. **User Control**: Ability to delete specific receipts

### What NOT to Extract

- Full bank account numbers
- Personal ID numbers
- Detailed recipient information (for transfers)
- Authentication/security codes

---
