# Financial Insights Generation

This document defines how PhoenixClaw Ledger analyzes spending patterns and generates actionable insights for the journal's Growth Notes section.

## Insight Categories

### 1. Spending Patterns

Identify recurring behaviors and habits:

```yaml
pattern_insights:
  - type: time_patterns
    examples:
      - "Most spending occurs on weekends (65%)"
      - "Friday evenings show highest food expenses"
      - "Morning coffee is a daily ¥25 habit"
      
  - type: category_patterns
    examples:
      - "Food delivery increased 40% this month"
      - "Subscription spending is steady at ¥200/month"
      - "Impulse purchases average ¥150 each"
```

### 2. Behavioral Observations

Deeper analysis of spending behavior:

```yaml
behavioral_insights:
  - type: impulse_detection
    criteria: "Purchase not mentioned before or after"
    examples:
      - "3 impulse purchases this week totaling ¥450"
      - "Electronics purchases often happen after payday"
      
  - type: social_spending
    criteria: "Multiple people mentioned in transaction"
    examples:
      - "Social meals average ¥180 (vs ¥45 solo)"
      - "Group activities account for 30% of entertainment"
      
  - type: emotional_spending
    criteria: "Correlate with mood from PhoenixClaw Core"
    examples:
      - "Spending increases on low-energy days"
      - "Retail therapy detected on 3 occasions"
```

### 3. Comparative Analysis

Compare across time periods:

```yaml
comparative_insights:
  - type: month_over_month
    examples:
      - "Total spending up 15% vs last month"
      - "Transport costs down 20% (more WFH days)"
      
  - type: category_shifts
    examples:
      - "Dining out replaced by groceries (+¥300)"
      - "New subscription added: Netflix (¥50/month)"
      
  - type: budget_adherence
    examples:
      - "Stayed under budget 3 months in a row! 🎉"
      - "Shopping category exceeded budget by ¥200"
```

### 4. Actionable Recommendations

Specific suggestions for improvement:

```yaml
recommendations:
  - type: cost_reduction
    trigger: "Category significantly over budget"
    examples:
      - "Consider cooking at home 2x more per week"
      - "Review subscription list - 3 unused services detected"
      
  - type: goal_alignment
    trigger: "Spending conflicts with stated goals"
    examples:
      - "Saving goal at risk: discretionary spending up"
      - "Travel fund on track with current savings rate"
      
  - type: optimization
    examples:
      - "Switching to annual subscription saves ¥100"
      - "Coffee shop rewards: 2 free drinks available"
```

## Insight Generation Rules

### Frequency Control

Avoid overwhelming users with too many insights:

```yaml
insight_limits:
  daily_journal:
    max_insights: 2
    priority: [alerts, notable_spending, patterns]
    
  weekly_summary:
    max_insights: 5
    priority: [trends, comparisons, recommendations]
    
  monthly_report:
    max_insights: 10
    include_all_categories: true
```

### Significance Thresholds

Only surface meaningful insights:

```yaml
thresholds:
  # Minimum change to report
  min_percent_change: 15
  min_absolute_change: 100
  
  # Pattern detection
  min_occurrences: 3          # Mention pattern after 3 instances
  pattern_window_days: 14     # Look back period
  
  # Anomaly detection
  anomaly_threshold: 2.0      # Standard deviations from mean
```

### Tone Guidelines

```yaml
tone:
  positive:
    - "Great progress on staying within budget!"
    - "Consistent spending habits this week 👍"
    
  neutral:
    - "Spending patterns this month:"
    - "Here's what I noticed:"
    
  concerned:
    - "Something to consider:"
    - "Worth reviewing:"
    
  # Never use
  avoid:
    - Judgmental language
    - Shame or guilt
    - Comparisons to others
```

## Insight Templates

### Daily Insight Block

```markdown
> [!insight] 💡 Today's Financial Insight
> {insight_content}
```

### Pattern Alert

```markdown
> [!pattern] 📊 Spending Pattern Detected
> **{pattern_name}**
> {pattern_description}
> 
> *Observed over the past {time_period}*
```

### Recommendation

```markdown
> [!tip] 💡 Suggestion
> {recommendation}
> 
> **Potential savings:** ¥{amount}/month
```

### Achievement

```markdown
> [!success] 🎉 Financial Win
> {achievement_description}
```

## Integration with Growth Notes

Ledger contributes to PhoenixClaw's Growth Notes section:

```yaml
growth_notes_contribution:
  section: "Financial Growth"
  icon: 💰
  
  content_types:
    - budget_achievements
    - spending_improvements
    - financial_goals_progress
    - habit_changes
    
  example_output: |
    ### 💰 Financial Growth
    - Stayed under food budget for 2 weeks straight
    - Reduced impulse purchases by 50% vs last month
    - On track for travel savings goal (¥2,400/¥5,000)
```

## Data Sources for Insights

### Required Data

```yaml
data_sources:
  current_period:
    - ledger.yaml (all transactions)
    - budget.yaml (budget state)
    
  historical:
    - Previous month's ledger
    - 3-month rolling average
    - Year-to-date totals
    
  from_core:
    - Mood/energy from PhoenixClaw
    - Goals from profile.md
    - Patterns from growth-map.md
```

### Cross-Plugin Correlations

When PhoenixClaw Core data is available:

```yaml
correlations:
  - source: mood
    insight: "Spending correlates with mood patterns"
    
  - source: energy
    insight: "Low-energy days show 25% higher delivery orders"
    
  - source: social
    insight: "Social events drive 40% of entertainment spending"
```

## Privacy Considerations

### What Gets Stored

```yaml
stored_insights:
  - Aggregated patterns (no individual transactions)
  - Category trends
  - Budget adherence metrics
  
never_stored:
  - Specific merchant names (in insights)
  - Exact amounts (use ranges)
  - Personal judgments
```

### User Control

```yaml
user_controls:
  disable_insights: false
  insight_detail_level: normal  # minimal | normal | detailed
  exclude_categories: []        # Hide from insights
  share_with_core: true         # Allow PhoenixClaw Core integration
```

---
