# Expense Detection from Conversations

This document defines how PhoenixClaw Ledger identifies financial transactions from natural conversation text.

## Detection Philosophy

Ledger uses **semantic understanding** rather than keyword matching. The AI considers context, intent, and linguistic patterns to identify genuine financial events while ignoring false positives.

## Supported Languages

Ledger supports multi-language expense detection:

| Language | Example Patterns |
|----------|------------------|
| Chinese | "花了150块", "买了个新耳机", "人均80" |
| English | "spent $50", "cost me about 30 bucks", "paid for dinner" |
| Mixed | "今天lunch花了20刀" |

## Semantic Patterns

### Expense Signals

| Pattern Type | Examples | Extracted Data |
|--------------|----------|----------------|
| **Direct Amount** | "spent ¥150", "花了150" | amount: 150 |
| **Per-Person** | "人均80，4个人", "$20 each, 5 people" | amount: 320 / 100 |
| **Purchase** | "bought a keyboard for 599", "买了个键盘599" | amount: 599, category: shopping |
| **Service** | "haircut was 80", "理发80" | amount: 80, category: personal |
| **Subscription** | "renewed Netflix", "续费了会员" | amount: inferred, category: subscription |
| **Transport** | "Uber cost 35", "打车35" | amount: 35, category: transport |

### Income Signals

| Pattern Type | Examples | Extracted Data |
|--------------|----------|----------------|
| **Salary** | "工资到账15k", "got paid $5000" | amount: +15000/+5000, type: income |
| **Reimbursement** | "报销到了800", "expense reimbursed" | amount: +800, type: income |
| **Transfer Received** | "他还了我200", "got 50 back from John" | amount: +200/+50, type: income |

### Transfer/Debt Signals

| Pattern Type | Examples | Extracted Data |
|--------------|----------|----------------|
| **Lent Money** | "借给他500", "lent him 100" | amount: 500, type: receivable |
| **Borrowed** | "问他借了1000", "borrowed 200" | amount: 1000, type: payable |
| **Split Bill** | "我先垫了400", "I covered the bill" | amount: 400, type: receivable |

## Extraction Schema

```yaml
detected_expense:
  amount: float              # Absolute value
  type: expense|income|transfer
  currency: string           # CNY, USD, EUR, etc.
  category_hint: string      # AI-inferred category
  description: string        # Brief description
  timestamp: ISO8601         # When mentioned (conversation time)
  confidence: float          # 0-1 detection confidence
  source: conversation
  context: string            # Surrounding text for verification
  people: string[]           # People involved (if mentioned)
```

## Confidence Scoring

| Confidence | Criteria | Action |
|------------|----------|--------|
| **High (≥0.85)** | Explicit amount + clear verb (spent, bought, paid) | Auto-record |
| **Medium (0.7-0.85)** | Amount present, context suggests transaction | Auto-record with review flag |
| **Low (<0.7)** | Ambiguous context or hypothetical | Do not record |

### Negative Signals (Reduce Confidence)

- Hypothetical language: "would cost", "might spend", "planning to buy"
- Questions: "how much is...?", "多少钱?"
- Past reference: "last year I spent...", "以前花过..."
- Quotes/Stories: "he told me it cost...", "他说花了..."

## Currency Detection

Priority order for currency inference:

1. **Explicit Symbol**: ¥, $, €, £
2. **Explicit Word**: "dollars", "块/元", "euros"
3. **User Config**: `default_currency` in settings
4. **Locale Inference**: Based on `user_config.language`

## Amount Parsing

| Format | Parsed As |
|--------|-----------|
| "150" | 150.00 |
| "150块" | 150.00 CNY |
| "$19.99" | 19.99 USD |
| "1.5k" / "1500" | 1500.00 |
| "15k" | 15000.00 |
| "人均80，3人" | 240.00 (calculated) |
| "about 50" | 50.00 (flagged as estimate) |

## False Positive Prevention

### Ignore These Contexts

- **Prices Without Purchase**: "The new iPhone costs $999" (just info, not a purchase)
- **Hypotheticals**: "If I bought it, I'd spend..."
- **Game/Virtual Currency**: "spent 1000 gold coins"
- **Historical Data**: "Back in 2020 I spent..."
- **Other People's Finances**: "My friend spent $500" (unless split/shared)

### Validation Rules

1. Transaction should relate to the user directly
2. Amount should be realistic for the category
3. Timestamp should be recent (today or explicitly stated)
4. Avoid duplicate detection from repeated mentions

## Integration with Screenshots

When both conversation and screenshot mention the same transaction:

1. **Screenshot takes priority** (more accurate data)
2. **Deduplicate by**: amount + approximate time (±30 min) + similar merchant
3. **Merge context**: Use conversation description + screenshot details

---
