# Cron Setup for PhoenixClaw Ledger

PhoenixClaw Ledger leverages the same cron infrastructure as PhoenixClaw Core, with additional scheduled tasks for financial reporting.

## Cron Jobs Overview

| Job | Schedule | Purpose |
|-----|----------|---------|
| Daily Processing | 10:00 PM | Extract transactions, update ledger |
| Monthly Report | 1st of month, 8:00 AM | Generate monthly financial summary |
| Weekly Report | Sunday, 9:00 PM | Generate weekly report & browser update |

## Daily Processing (Automatic)

Ledger hooks into PhoenixClaw Core's nightly cron. No separate setup required if Core is already configured.

When Core runs at 10 PM:
1. Core identifies moments from the day's conversations
2. **Ledger plugin activates** at `post-moment-analysis` hook
3. Ledger extracts financial data from moments and screenshots
4. Ledger generates the `💰 Financial Summary` section
5. Core includes it in the daily journal

## Monthly Report Setup

Register a monthly cron job to generate comprehensive financial reports:

```bash
openclaw cron add \
  --name "PhoenixClaw Ledger monthly report" \
  --cron "0 8 1 * *" \
  --tz "auto" \
  --session isolated \
  --message "Generate monthly financial report for the previous month. Analyze spending patterns, compare to budget, identify trends, and create actionable insights. Save to ~/PhoenixClaw/Finance/monthly/."
```

### Cron Expression Breakdown

```
0 8 1 * *
│ │ │ │ │
│ │ │ │ └── Any day of week
│ │ │ └──── Any month
│ │ └────── 1st day of month
│ └──────── 8:00 AM
└────────── 0 minutes
```

### Why 8 AM on the 1st?

- Runs after all previous month's transactions are captured
- Morning timing ensures report is ready for monthly review
- Avoids conflict with nightly journal generation

## Weekly Report Setup

Generate comprehensive weekly financial reports every Sunday evening. This report provides a detailed breakdown of the week's spending, income, and budget utilization using the [weekly-report.md](../assets/weekly-report.md) template.

```bash
openclaw cron add \
  --name "PhoenixClaw Ledger weekly report" \
  --cron "0 21 * * 0" \
  --tz "auto" \
  --session isolated \
  --message "Generate weekly financial report. Analyze spending vs budget, identify top expenses, and prepare summary for Sunday's journal. Save to ~/PhoenixClaw/Finance/weekly/."
```

### Output Path
Reports are saved to: `~/PhoenixClaw/Finance/weekly/YYYY-WNN.md` (where `WNN` is the week number).

### Sunday Journal Integration
The weekly report is also automatically embedded in Sunday's daily journal entry for quick review.

## Transaction Browser Regeneration (Optional)

The Transaction Browser is a searchable Markdown index of all financial activity. You can schedule it to regenerate periodically (e.g., nightly) to ensure the index stays up-to-date.

```bash
openclaw cron add \
  --name "PhoenixClaw Ledger browser refresh" \
  --cron "0 23 * * *" \
  --tz "auto" \
  --session isolated \
  --message "Regenerate the transaction browser index to include today's new entries."
```

Note: Regeneration can also be triggered manually using `openclaw run "Refresh transaction browser"`.

## Verification

Check all Ledger-related cron jobs:

```bash
openclaw cron list | grep -i ledger
```

Expected output:
```
PhoenixClaw Ledger monthly report    0 8 1 * *     active
PhoenixClaw Ledger weekly report     0 21 * * 0    active
PhoenixClaw Ledger browser refresh   0 23 * * *    active
```

## Manual Triggers

Generate reports on-demand without waiting for cron:

```bash
# Generate current month's report (in progress)
openclaw run "Generate financial report for this month so far"

# Generate specific month's report
openclaw run "Generate financial report for January 2026"

# Quick spending check
openclaw run "How much have I spent this week?"
```

## Report Storage

| Report Type | Path | Generated |
|-------------|------|-----------|
| Daily section | `Journal/daily/YYYY-MM-DD.md` | Nightly |
| Monthly report | `Finance/monthly/YYYY-MM.md` | 1st of month |
| Weekly report | `Finance/weekly/YYYY-WNN.md` | Sundays |
| Transaction Browser | `Finance/transactions.md` | Scheduled/Manual |
| Annual report | `Finance/yearly/YYYY.md` | Jan 1st |

## Dependency on Core

Ledger requires PhoenixClaw Core to be installed and its cron configured:

```bash
# Verify Core cron is active
openclaw cron list | grep "PhoenixClaw nightly"
```

If Core cron is not set up, Ledger's daily processing won't trigger automatically. See Core's `references/cron-setup.md` for initial setup.

## Timezone Considerations

- All cron jobs should use consistent timezone
- `--tz "auto"` inherits from Core's configuration
- For explicit timezone: `--tz "Asia/Shanghai"` or `--tz "America/New_York"`

## Troubleshooting

### Monthly report not generating

1. Check cron registration:
   ```bash
   openclaw cron list
   ```

2. Check execution history:
   ```bash
   openclaw cron history "PhoenixClaw Ledger monthly report"
   ```

3. Verify ledger.yaml exists:
   ```bash
   ls ~/PhoenixClaw/Finance/ledger.yaml
   ```

### Missing transactions in report

1. Ensure daily cron ran successfully for all days
2. Check for gaps in ledger.yaml
3. Manual backfill if needed:
   ```bash
   openclaw run "Scan memory for 2026-01-15 and extract any financial transactions"
   ```

### Budget alerts not appearing

1. Verify budget.yaml configuration exists
2. Check budget thresholds in config:
   ```bash
   cat ~/.phoenixclaw/config.yaml | grep -A 10 budget
   ```
