# Category Rules and Definitions

This document defines the expense category system, including hierarchy, icons, and behavioral rules.

## Category Schema

```yaml
category:
  id: string           # Unique identifier (lowercase, no spaces)
  name: string         # Display name (localized)
  icon: string         # Emoji icon
  color: string        # Hex color for charts
  parent: string?      # Parent category ID (for subcategories)
  budget_default: float?  # Default budget allocation %
  is_essential: boolean   # Essential vs discretionary
```

## Default Categories

### Essential Categories

| ID | Name (EN) | Name (ZH) | Icon | Color | Budget % |
|----|-----------|-----------|------|-------|----------|
| `housing` | Housing | 居住 | 🏠 | #4CAF50 | 30% |
| `utilities` | Utilities | 账单 | 📱 | #2196F3 | 10% |
| `food` | Food & Dining | 餐饮 | 🍜 | #FF9800 | 15% |
| `transport` | Transportation | 交通 | 🚗 | #9C27B0 | 10% |
| `health` | Health | 健康 | 💊 | #E91E63 | 5% |

### Discretionary Categories

| ID | Name (EN) | Name (ZH) | Icon | Color | Budget % |
|----|-----------|-----------|------|-------|----------|
| `shopping` | Shopping | 购物 | 🛒 | #F44336 | 10% |
| `entertainment` | Entertainment | 娱乐 | 🎬 | #673AB7 | 5% |
| `personal` | Personal Care | 个护 | 💈 | #00BCD4 | 5% |
| `education` | Education | 教育 | 📚 | #3F51B5 | 5% |
| `subscription` | Subscriptions | 订阅 | 🔄 | #607D8B | 3% |

### Special Categories

| ID | Name (EN) | Name (ZH) | Icon | Notes |
|----|-----------|-----------|------|-------|
| `income` | Income | 收入 | 💰 | Positive amounts |
| `transfer` | Transfers | 转账 | 💸 | Neutral, excludes from totals |
| `other` | Other | 其他 | 📦 | Fallback category |

## Subcategory Definitions

### Food & Dining (`food`)

```yaml
food:
  subcategories:
    - id: food.restaurant
      name: Restaurants
      name_zh: 餐厅
      icon: 🍽️
      
    - id: food.delivery
      name: Delivery
      name_zh: 外卖
      icon: 🛵
      
    - id: food.groceries
      name: Groceries
      name_zh: 生鲜
      icon: 🥬
      
    - id: food.coffee
      name: Coffee & Tea
      name_zh: 咖啡茶饮
      icon: ☕
      
    - id: food.snacks
      name: Snacks
      name_zh: 零食
      icon: 🍿
```

### Transportation (`transport`)

```yaml
transport:
  subcategories:
    - id: transport.rideshare
      name: Rideshare
      name_zh: 打车
      icon: 🚕
      
    - id: transport.public
      name: Public Transit
      name_zh: 公共交通
      icon: 🚇
      
    - id: transport.fuel
      name: Fuel
      name_zh: 加油
      icon: ⛽
      
    - id: transport.parking
      name: Parking
      name_zh: 停车
      icon: 🅿️
      
    - id: transport.flights
      name: Flights
      name_zh: 机票
      icon: ✈️
```

### Shopping (`shopping`)

```yaml
shopping:
  subcategories:
    - id: shopping.electronics
      name: Electronics
      name_zh: 数码
      icon: 📱
      
    - id: shopping.clothing
      name: Clothing
      name_zh: 服饰
      icon: 👕
      
    - id: shopping.home
      name: Home & Living
      name_zh: 家居
      icon: 🛋️
      
    - id: shopping.gifts
      name: Gifts
      name_zh: 礼物
      icon: 🎁
```

## Category Behaviors

### Aggregation Rules

```yaml
aggregation:
  # These categories roll up to parent
  roll_up:
    - food.*    → food
    - transport.* → transport
    
  # These are counted separately
  separate:
    - income    # Never mixed with expenses
    - transfer  # Excluded from spending totals
```

### Budget Inheritance

```yaml
budget_rules:
  # Subcategories inherit from parent unless specified
  food: 2000
  food.delivery: 500    # Specific limit within food
  food.coffee: 300      # Specific limit within food
  # food.restaurant uses remaining food budget
```

### Display Order

Categories appear in this order in reports:

1. Essential categories (by budget %)
2. Discretionary categories (by budget %)
3. Other
4. Income (separate section)
5. Transfers (if shown)

## Localization

Category names support multiple languages:

```yaml
categories:
  food:
    name:
      en: "Food & Dining"
      zh: "餐饮"
      ja: "食費"
      ko: "식비"
    icon: 🍜
```

### Language Selection

1. Use `user_config.language` setting
2. Fallback to English if translation unavailable
3. Icons are universal (no translation needed)

## Custom Categories

Users can create custom categories:

```yaml
# ~/.phoenixclaw/config.yaml
plugins:
  phoenixclaw-ledger:
    custom_categories:
      - id: pets
        name: Pets
        name_zh: 宠物
        icon: 🐱
        color: "#8BC34A"
        is_essential: false
        budget_default: 5
```

### Custom Category Rules

- ID must be unique, lowercase, no spaces
- Must not conflict with default category IDs
- Icon should be a single emoji
- Color must be valid hex code

## Category Analysis

### Spending Health Indicators

```yaml
health_checks:
  # Warn if category exceeds threshold
  - category: food.delivery
    warn_if_exceeds: 40%  # of total food
    message: "Delivery spending is high"
    
  - category: entertainment
    warn_if_exceeds: 15%  # of total spending
    message: "Entertainment spending above typical"
    
  - category: subscription
    warn_if_count_exceeds: 10
    message: "You have many active subscriptions"
```

### Category Trends

Track month-over-month changes:

```yaml
trend_analysis:
  compare_periods: 3  # Compare to last 3 months
  significant_change: 20%  # Alert if >20% change
  
  # Generate insights like:
  # "Food spending up 25% from last month"
  # "Transportation down 15% - nice improvement!"
```

---
