---
type: yearly-finance
year: {{YEAR}}
total_income: {{TOTAL_INCOME}}
total_expense: {{TOTAL_EXPENSE}}
net: {{NET}}
currency: {{CURRENCY}}
generated: {{GENERATED_DATE}}
---

# {{YEAR}} Annual Financial Report

## Overview

| Metric | Amount |
|--------|--------|
| Total Income | {{CURRENCY}}{{TOTAL_INCOME}} |
| Total Expenses | {{CURRENCY}}{{TOTAL_EXPENSE}} |
| **Net Savings** | **{{CURRENCY}}{{NET}}** |
| Savings Rate | {{SAVINGS_RATE}}% |

## Monthly Breakdown

| Month | Income | Expenses | Net | Budget Status |
|-------|--------|----------|-----|---------------|
{{#each MONTHS}}
| {{name}} | {{income}} | {{expense}} | {{net}} | {{status}} |
{{/each}}

## Category Summary

### Top Expense Categories

| Category | Annual Total | Monthly Avg | % of Total |
|----------|--------------|-------------|------------|
{{#each TOP_CATEGORIES}}
| {{icon}} {{name}} | {{total}} | {{avg}} | {{percent}}% |
{{/each}}

### Category Trends

```
{{CATEGORY_TREND_CHART}}
```

## Quarterly Analysis

| Quarter | Income | Expenses | Net |
|---------|--------|----------|-----|
| Q1 (Jan-Mar) | {{Q1_INCOME}} | {{Q1_EXPENSE}} | {{Q1_NET}} |
| Q2 (Apr-Jun) | {{Q2_INCOME}} | {{Q2_EXPENSE}} | {{Q2_NET}} |
| Q3 (Jul-Sep) | {{Q3_INCOME}} | {{Q3_EXPENSE}} | {{Q3_NET}} |
| Q4 (Oct-Dec) | {{Q4_INCOME}} | {{Q4_EXPENSE}} | {{Q4_NET}} |

## Key Insights

{{#each INSIGHTS}}
> [!{{type}}] {{title}}
> {{content}}

{{/each}}

## Year-over-Year Comparison

{{#if PREVIOUS_YEAR}}
| Metric | {{PREVIOUS_YEAR}} | {{YEAR}} | Change |
|--------|-------------------|----------|--------|
| Income | {{PREV_INCOME}} | {{CURR_INCOME}} | {{INCOME_CHANGE}} |
| Expenses | {{PREV_EXPENSE}} | {{CURR_EXPENSE}} | {{EXPENSE_CHANGE}} |
| Savings | {{PREV_SAVINGS}} | {{CURR_SAVINGS}} | {{SAVINGS_CHANGE}} |
{{else}}
*First year of tracking - no comparison available*
{{/if}}

## Recurring Expenses Summary

| Item | Monthly | Annual | % of Expenses |
|------|---------|--------|---------------|
{{#each RECURRING}}
| {{name}} | {{monthly}} | {{annual}} | {{percent}}% |
{{/each}}

**Total Recurring:** {{CURRENCY}}{{RECURRING_TOTAL}}/year

## Financial Goals

{{#each GOALS}}
- {{name}}: {{progress}}/{{target}} ({{percent}}%) {{status_icon}}
{{/each}}

## Recommendations for Next Year

{{#each RECOMMENDATIONS}}
1. {{content}}
{{/each}}

---
*Generated by PhoenixClaw Ledger*
*Report date: {{GENERATED_DATE}}*
