---
type: weekly-finance
week: {{WEEK}}
total_income: {{TOTAL_INCOME}}
total_expense: {{TOTAL_EXPENSE}}
net: {{NET}}
budget: {{BUDGET}}
currency: {{CURRENCY}}
generated: {{GENERATED_DATE}}
---

# 💰 Week {{WEEK}} Financial Report
*{{WEEK_RANGE}}*

## 📊 Overview

| Metric | Amount |
|--------|--------|
| Total Income | {{CURRENCY}}{{TOTAL_INCOME}} |
| Total Expenses | {{CURRENCY}}{{TOTAL_EXPENSE}} |
| **Net** | **{{CURRENCY}}{{NET}}** |
| Budget | {{CURRENCY}}{{BUDGET}} |
| Budget Used | {{BUDGET_PERCENT}}% |

## 📅 Daily Spending Breakdown

| Day | Date | Income | Expense | Net |
|-----|------|--------|---------|-----|
| Mon | {{MON_DATE}} | {{MON_INCOME}} | {{MON_EXPENSE}} | {{MON_NET}} |
| Tue | {{TUE_DATE}} | {{TUE_INCOME}} | {{TUE_EXPENSE}} | {{TUE_NET}} |
| Wed | {{WED_DATE}} | {{WED_INCOME}} | {{WED_EXPENSE}} | {{WED_NET}} |
| Thu | {{THU_DATE}} | {{THU_INCOME}} | {{THU_EXPENSE}} | {{THU_NET}} |
| Fri | {{FRI_DATE}} | {{FRI_INCOME}} | {{FRI_EXPENSE}} | {{FRI_NET}} |
| Sat | {{SAT_DATE}} | {{SAT_INCOME}} | {{SAT_EXPENSE}} | {{SAT_NET}} |
| Sun | {{SUN_DATE}} | {{SUN_INCOME}} | {{SUN_EXPENSE}} | {{SUN_NET}} |
| **Total** | | **{{TOTAL_INCOME}}** | **{{TOTAL_EXPENSE}}** | **{{NET}}** |

## 📈 Expense Breakdown

### By Category

| Category | Amount | % of Total | vs Last Week |
|----------|--------|------------|--------------|
{{#each CATEGORIES}}
| {{icon}} {{name}} | {{currency}}{{amount}} | {{percent}}% | {{trend}} |
{{/each}}

### Visualization

```
{{CATEGORY_CHART}}
```

## 💳 Top Expenses

| Date | Description | Category | Amount |
|------|-------------|----------|--------|
{{#each TOP_EXPENSES}}
| {{date}} | {{description}} | {{category}} | {{currency}}{{amount}} |
{{/each}}

## 🔄 Week-over-Week Comparison

| Metric | This Week | Last Week | Change |
|--------|-----------|-----------|--------|
| Total Spent | {{CURRENCY}}{{TOTAL_EXPENSE}} | {{CURRENCY}}{{PREV_WEEK_EXPENSE}} | {{EXPENSE_CHANGE}} |
| Daily Average | {{CURRENCY}}{{DAILY_AVERAGE}} | {{CURRENCY}}{{PREV_DAILY_AVERAGE}} | {{AVG_CHANGE}} |
| Largest Category | {{TOP_CATEGORY}} | {{PREV_TOP_CATEGORY}} | - |

## 💡 Insights

{{#each INSIGHTS}}
> [!{{type}}] {{title}}
> {{content}}

{{/each}}

## 📅 Sunday Journal Integration

The following section is embedded in Sunday's daily journal:

```markdown
## 📊 This Week's Summary

> [!summary] Weekly Finance: {{WEEK}}
> - **Total Spent:** {{CURRENCY}}{{TOTAL_EXPENSE}} ({{EXPENSE_CHANGE}} vs last week)
> - **Top Category:** {{TOP_CATEGORY}} ({{CURRENCY}}{{TOP_CATEGORY_AMOUNT}})
> - **Net Balance:** {{CURRENCY}}{{NET}}
> 
> [[Finance/weekly/{{WEEK}}.md|View Full Weekly Report →]]
```

---
*Generated by PhoenixClaw Ledger 💰*
*Report date: {{GENERATED_DATE}}*

---

## Template Variables Reference

| Variable | Description | Example |
|----------|-------------|---------|
| `{{WEEK}}` | ISO Week identifier | 2026-W06 |
| `{{WEEK_RANGE}}` | Date range of the week | Feb 2, 2026 - Feb 8, 2026 |
| `{{CURRENCY}}` | Currency symbol | ¥ |
| `{{TOTAL_INCOME}}` | Total income for the week | 1500.00 |
| `{{TOTAL_EXPENSE}}` | Total expenses for the week | 1234.00 |
| `{{NET}}` | Net (income - expense) | 266.00 |
| `{{BUDGET}}` | Weekly budget | 1500.00 |
| `{{BUDGET_PERCENT}}` | Budget utilization percentage | 82 |
| `{{EXPENSE_CHANGE}}` | Week-over-week change in spending | ↑12% |
