---
date: {{DATE}}
type: trend-analysis
period: {{PERIOD_TYPE}} # 3m | 6m | custom
range: {{START_DATE}} to {{END_DATE}}
tags: [finance, phoenixclaw, trend]
---

# 📊 Spending Trend Analysis ({{PERIOD_TYPE_LABEL}})

**Period:** {{START_DATE}} to {{END_DATE}}
**Total Spending:** {{CURRENCY}}{{TOTAL_SPENT}}
**Avg. per Period:** {{CURRENCY}}{{PERIOD_AVERAGE}}

---

{{#if IS_3M}}
## 🗓️ 3-Month Weekly Trend (12 Weeks)

| Week | Date Range | Total | ASCII Sparkline |
|:-----|:-----------|:------|:----------------|
{{#each WEEKS}}
| W{{index}} | {{label}} | {{CURRENCY}}{{amount}} | `{{sparkline}}` |
{{/each}}

{{/if}}
{{#if IS_6M}}
## 🗓️ 6-Month Monthly Trend

| Month | Total | ASCII Sparkline |
|:------|:------|:----------------|
{{#each MONTHS}}
| {{label}} | {{CURRENCY}}{{amount}} | `{{sparkline}}` |
{{/each}}

{{/if}}
{{#if IS_CUSTOM}}
## 🗓️ Custom Range Analysis
**From:** {{START_DATE}}
**To:** {{END_DATE}}

| Period | Total |
|:-------|:------|
{{#each CUSTOM_PERIODS}}
| {{label}} | {{CURRENCY}}{{amount}} |
{{/each}}

{{/if}}

---

## 🗂️ Category Trend Breakdown

```text
{{CATEGORY_ASCII_CHART}}
```

| Category | Total | % of Total | vs. Previous |
|:---------|:------|:-----------|:-------------|
{{#each CATEGORY_TRENDS}}
| {{name}} | {{CURRENCY}}{{amount}} | {{percent}}% | {{diff_pct}}% {{#if is_up}}🔺{{else}}🔻{{/if}} |
{{/each}}

---

## 💡 Comparative Insights

> [!insight] Performance vs. Previous Period
{{#each COMPARATIVE_INSIGHTS}}
> - **{{type}}**: {{description}}
{{/each}}

## 💭 Observations & Patterns
{{#each OBSERVATIONS}}
- {{this}}
{{/each}}

---
Generated by [[PhoenixClaw Ledger]]
