# Receipt Callout Template

Template for displaying expenses extracted from payment screenshots.

## Template

```markdown
> [!receipt] 💳 {{TIME}} {{PLATFORM}}
> ![[{{SCREENSHOT_PATH}}|300]]
> 
> | Field | Value |
> |-------|-------|
> | Merchant | {{MERCHANT}} |
> | Amount | **{{CURRENCY}}{{AMOUNT}}** |
> | Method | {{PAYMENT_METHOD}} |
> {{#if DISCOUNT}}
> | Discount | -{{CURRENCY}}{{DISCOUNT}} |
> {{/if}}
> {{#if ORIGINAL_AMOUNT}}
> | Original | ~~{{CURRENCY}}{{ORIGINAL_AMOUNT}}~~ |
> {{/if}}
> 
> *Source: {{PLATFORM}} screenshot*
```

## Variables

| Variable | Description | Example |
|----------|-------------|---------|
| `{{TIME}}` | Transaction time | 14:32 |
| `{{PLATFORM}}` | Payment platform | WeChat Pay |
| `{{SCREENSHOT_PATH}}` | Path to receipt image | assets/2026-02-02/receipt_001.jpg |
| `{{MERCHANT}}` | Merchant/store name | Luckin Coffee (Wangjing) |
| `{{CURRENCY}}` | Currency symbol | ¥ |
| `{{AMOUNT}}` | Final paid amount | 19.90 |
| `{{PAYMENT_METHOD}}` | Payment method used | WeChat Balance |
| `{{DISCOUNT}}` | Discount amount (optional) | 5.00 |
| `{{ORIGINAL_AMOUNT}}` | Pre-discount amount (optional) | 24.90 |

## Platform Names

| Platform Code | Display Name |
|---------------|--------------|
| `wechat` | WeChat Pay |
| `alipay` | Alipay |
| `apple_pay` | Apple Pay |
| `google_pay` | Google Pay |
| `unionpay` | UnionPay |
| `paypal` | PayPal |
| `bank` | Bank Transfer |
| `unknown` | Payment |

## Examples

### Basic Receipt

```markdown
> [!receipt] 💳 14:32 WeChat Pay
> ![[assets/2026-02-02/receipt_001.jpg|300]]
> 
> | Field | Value |
> |-------|-------|
> | Merchant | Luckin Coffee |
> | Amount | **¥19.90** |
> | Method | WeChat Balance |
> 
> *Source: WeChat Pay screenshot*
```

### With Discount

```markdown
> [!receipt] 💳 12:15 Alipay
> ![[assets/2026-02-02/receipt_002.jpg|300]]
> 
> | Field | Value |
> |-------|-------|
> | Merchant | Freshippo (Hema) |
> | Amount | **¥86.50** |
> | Original | ~~¥96.50~~ |
> | Discount | -¥10.00 |
> | Method | Credit Card |
> 
> *Source: Alipay screenshot*
```

### Bank Transfer

```markdown
> [!receipt] 💳 10:00 Bank Transfer
> ![[assets/2026-02-02/receipt_003.jpg|300]]
> 
> | Field | Value |
> |-------|-------|
> | Type | Incoming Transfer |
> | Amount | **+¥5,000.00** |
> | From | **** 1234 |
> | Method | Bank Account |
> 
> *Source: Bank App screenshot*
```

## Compact Format

For multiple receipts, use compact format:

```markdown
> [!receipt] 💳 14:32 WeChat Pay
> ![[assets/2026-02-02/receipt_001.jpg|200]]
> Luckin Coffee | **¥19.90** | Food & Dining
> *Auto-detected from screenshot*
```

## Styling Notes

- Image width: 300px for detailed view, 200px for compact
- Use Obsidian table for structured data
- Strikethrough (~~) for original prices when discounted
- Mask sensitive data (last 4 digits only for cards)
- Bold the final amount paid
- Positive amounts (income) prefixed with `+`

## Low Confidence Indicator

When extraction confidence is below threshold:

```markdown
> [!receipt] 💳 14:32 WeChat Pay
> ![[assets/2026-02-02/receipt_001.jpg|300]]
> 
> | Field | Value |
> |-------|-------|
> | Merchant | Luckin Coffee |
> | Amount | **¥19.90** ⚠️ |
> | Method | Unknown |
> 
> *Source: WeChat Pay screenshot • Please verify*
```

## Gallery Format

For multiple receipts in one day:

```markdown
> [!receipt-gallery] 💳 Today's Receipts
> ![[assets/2026-02-02/receipt_001.jpg|150]] ![[assets/2026-02-02/receipt_002.jpg|150]] ![[assets/2026-02-02/receipt_003.jpg|150]]
> 
> **Total:** ¥256.40 from 3 transactions
```
