---
type: monthly-finance
period: {{PERIOD}}
total_income: {{TOTAL_INCOME}}
total_expense: {{TOTAL_EXPENSE}}
net: {{NET}}
budget: {{BUDGET}}
currency: {{CURRENCY}}
generated: {{GENERATED_DATE}}
---

# 💰 {{PERIOD_DISPLAY}} Financial Report

## 📊 Overview

| Metric | Amount |
|--------|--------|
| Total Income | {{CURRENCY}}{{TOTAL_INCOME}} |
| Total Expenses | {{CURRENCY}}{{TOTAL_EXPENSE}} |
| **Net** | **{{CURRENCY}}{{NET}}** |
| Budget | {{CURRENCY}}{{BUDGET}} |
| Budget Used | {{BUDGET_PERCENT}}% |

## 📈 Expense Breakdown

### By Category

| Category | Amount | % of Total | vs Last Month |
|----------|--------|------------|---------------|
{{#each CATEGORIES}}
| {{icon}} {{name}} | {{currency}}{{amount}} | {{percent}}% | {{trend}} |
{{/each}}

### Visualization

```
{{CATEGORY_CHART}}
```

## 📅 Daily Spending Pattern

| Week | Mon | Tue | Wed | Thu | Fri | Sat | Sun | Total |
|------|-----|-----|-----|-----|-----|-----|-----|-------|
{{#each WEEKS}}
| W{{week}} | {{mon}} | {{tue}} | {{wed}} | {{thu}} | {{fri}} | {{sat}} | {{sun}} | {{total}} |
{{/each}}

**Average daily:** {{CURRENCY}}{{DAILY_AVERAGE}}
**Highest day:** {{HIGHEST_DAY}} ({{CURRENCY}}{{HIGHEST_AMOUNT}})
**No-spend days:** {{NO_SPEND_DAYS}}

## 💳 Top Transactions

### Largest Expenses

| Date | Description | Category | Amount |
|------|-------------|----------|--------|
{{#each TOP_EXPENSES}}
| {{date}} | {{description}} | {{category}} | {{currency}}{{amount}} |
{{/each}}

### Income Sources

| Date | Description | Amount |
|------|-------------|--------|
{{#each INCOME_ENTRIES}}
| {{date}} | {{description}} | +{{currency}}{{amount}} |
{{/each}}

## 🔄 Recurring Expenses

| Item | Frequency | Amount | Annual Cost |
|------|-----------|--------|-------------|
{{#each RECURRING}}
| {{name}} | {{frequency}} | {{currency}}{{amount}} | {{currency}}{{annual}} |
{{/each}}

**Total subscriptions:** {{CURRENCY}}{{SUBSCRIPTION_TOTAL}}/month

## 📊 Trends & Comparisons

### Month-over-Month

| Category | This Month | Last Month | Change |
|----------|------------|------------|--------|
{{#each MOM_COMPARISON}}
| {{category}} | {{current}} | {{previous}} | {{change}} |
{{/each}}

### Year-to-Date

- **Total spent:** {{CURRENCY}}{{YTD_TOTAL}}
- **Monthly average:** {{CURRENCY}}{{YTD_AVERAGE}}
- **Highest month:** {{HIGHEST_MONTH}} ({{CURRENCY}}{{HIGHEST_MONTH_AMOUNT}})
- **Lowest month:** {{LOWEST_MONTH}} ({{CURRENCY}}{{LOWEST_MONTH_AMOUNT}})

## 💡 Insights

{{#each INSIGHTS}}
> [!{{type}}] {{title}}
> {{content}}

{{/each}}

## 🎯 Budget Performance

### Category Budgets

| Category | Budget | Actual | Status |
|----------|--------|--------|--------|
{{#each BUDGET_PERFORMANCE}}
| {{category}} | {{budget}} | {{actual}} | {{status_icon}} {{status}} |
{{/each}}

### Recommendations

{{#each RECOMMENDATIONS}}
- {{content}}
{{/each}}

## 📎 Attachments

- **Receipts:** {{RECEIPT_COUNT}} screenshots stored
- **Data file:** [[Finance/ledger.yaml|View raw data]]

---
*Generated by PhoenixClaw Ledger 💰*
*Report date: {{GENERATED_DATE}}*

---

## Template Variables Reference

### Header Variables

| Variable | Description | Example |
|----------|-------------|---------|
| `{{PERIOD}}` | Period identifier | 2026-02 |
| `{{PERIOD_DISPLAY}}` | Display format | February 2026 |
| `{{CURRENCY}}` | Currency symbol | ¥ |
| `{{TOTAL_INCOME}}` | Total income | 15,000.00 |
| `{{TOTAL_EXPENSE}}` | Total expenses | 8,234.00 |
| `{{NET}}` | Net (income - expense) | 6,766.00 |
| `{{BUDGET}}` | Budget amount | 5,000.00 |
| `{{BUDGET_PERCENT}}` | Budget utilization | 165 |
| `{{GENERATED_DATE}}` | Report generation date | 2026-02-28 |

### Category Entry

```yaml
category:
  icon: 🍜
  name: Food & Dining
  amount: 2,340.00
  percent: 28
  trend: ↑15%  # or ↓8%, →
```

### Insight Entry

```yaml
insight:
  type: insight|warning|success|tip
  title: Spending Pattern
  content: Weekend dining accounts for 60% of food expenses
```

### Status Icons

| Status | Icon |
|--------|------|
| Under budget | ✅ |
| Near limit (80-100%) | ⚠️ |
| Over budget | ❌ |
| No budget set | ➖ |

## Example Output

```markdown
---
type: monthly-finance
period: 2026-02
total_income: 15000.00
total_expense: 8234.00
net: 6766.00
budget: 5000.00
currency: CNY
generated: 2026-02-28
---

# 💰 February 2026 Financial Report

## 📊 Overview

| Metric | Amount |
|--------|--------|
| Total Income | ¥15,000.00 |
| Total Expenses | ¥8,234.00 |
| **Net** | **¥6,766.00** |
| Budget | ¥5,000.00 |
| Budget Used | 165% |

## 📈 Expense Breakdown

### By Category

| Category | Amount | % of Total | vs Last Month |
|----------|--------|------------|---------------|
| 🍜 Food & Dining | ¥2,340.00 | 28% | ↑15% |
| 🛒 Shopping | ¥1,890.00 | 23% | ↓8% |
| 🚗 Transportation | ¥580.00 | 7% | → |
| 🎬 Entertainment | ¥450.00 | 5% | ↑25% |
| 🔄 Subscriptions | ¥200.00 | 2% | → |
| 📦 Other | ¥2,774.00 | 34% | ↑5% |

## 💡 Insights

> [!insight] Spending Pattern
> Weekend spending accounts for 45% of total expenses

> [!warning] Budget Alert
> Exceeded monthly budget by ¥3,234

> [!tip] Suggestion
> Consider meal prepping to reduce food delivery costs

---
*Generated by PhoenixClaw Ledger 💰*
*Report date: 2026-02-28*
```
