# Expense Callout Template

Template for displaying expenses detected from conversation text.

## Template

```markdown
> [!expense] {{ICON}} {{TIME}} {{DESCRIPTION}}
> {{DETAILS}} | **{{CURRENCY}}{{AMOUNT}}** | {{CATEGORY}}
> *Source: Conversation*
```

## Variables

| Variable | Description | Example |
|----------|-------------|---------|
| `{{ICON}}` | Category emoji | 🍜, 🚗, 🛒 |
| `{{TIME}}` | Transaction time (HH:MM) | 12:30 |
| `{{DESCRIPTION}}` | Brief description | Lunch |
| `{{DETAILS}}` | Additional context | "With colleagues at hotpot restaurant" |
| `{{CURRENCY}}` | Currency symbol | ¥, $, € |
| `{{AMOUNT}}` | Transaction amount | 150.00 |
| `{{CATEGORY}}` | Category name | Food & Dining |

## Icon Mapping

| Category | Icon |
|----------|------|
| Food & Dining | 🍜 |
| Transportation | 🚗 |
| Shopping | 🛒 |
| Entertainment | 🎬 |
| Utilities | 📱 |
| Housing | 🏠 |
| Health | 💊 |
| Education | 📚 |
| Personal | 💈 |
| Subscription | 🔄 |
| Income | 💰 |
| Transfer | 💸 |
| Other | 📦 |

## Examples

### Basic Expense

```markdown
> [!expense] 🍜 12:30 Lunch
> Hotpot with colleagues | **¥150.00** | Food & Dining
> *Source: Conversation*
```

### With People

```markdown
> [!expense] 🍜 19:00 Dinner
> Birthday celebration with Alice and Bob | **¥320.00** | Food & Dining
> *Source: Conversation*
```

### Transport

```markdown
> [!expense] 🚗 08:15 Commute
> Rideshare to office | **¥35.00** | Transportation
> *Source: Conversation*
```

### Shopping

```markdown
> [!expense] 🛒 15:30 Electronics
> New wireless earbuds | **¥299.00** | Shopping
> *Source: Conversation*
```

### Income

```markdown
> [!income] 💰 10:00 Salary
> Monthly salary deposited | **+¥15,000.00** | Income
> *Source: Conversation*
```

## Styling Notes

- Use `>` for Obsidian callout syntax
- Category icon provides quick visual identification
- Amount is bold for emphasis
- Positive amounts (income) prefixed with `+`
- Source line italicized for de-emphasis
- Keep description concise (under 50 characters)

## Confidence Indicator (Optional)

For medium-confidence detections:

```markdown
> [!expense] 🛒 14:00 Purchase
> Online shopping | **¥199.00** | Shopping
> *Source: Conversation • ⚠️ Verify amount*
```
