---
name: phoenixclaw-ledger
description: |
  Passive financial tracking plugin for PhoenixClaw.
  Automatically detects expenses and income from conversations and payment screenshots.
  
  Use when:
  - User mentions money/spending (any language)
  - User shares payment screenshots (WeChat Pay, Alipay, etc.)
  - User asks about finances ("How much did I spend?", "My budget")
  - User wants expense reports ("Monthly summary", "Spending analysis")

metadata:
  version: 0.1.0

depends: phoenixclaw
protocol_version: 1
min_core_version: 0.0.3
hook_point: post-moment-analysis
data_access:
  - moments
  - user_config
  - memory
export_to_journal: true
---

# PhoenixClaw Ledger: Zero-Effort Financial Tracking

PhoenixClaw Ledger automatically extracts financial transactions from your daily conversations and payment screenshots, requiring zero manual input.

## Core Capabilities

| Feature | Description |
|---------|-------------|
| **Semantic Expense Detection** | AI identifies spending mentions in natural conversation |
| **Screenshot Recognition** | Extracts transaction data from payment app screenshots |
| **Smart Categorization** | Auto-categorizes based on merchant and context |
| **Budget Tracking** | Monthly budget alerts and progress visualization |
| **Financial Insights** | Pattern analysis integrated into journal Growth Notes |
| **Goal Management** | Savings, budget control, habit, and wishlist goals |
| **Weekly Reports** | Automated Sunday 9 PM spending recap |
| **Query Support** | Real-time natural language financial inquiries |
| **Spending Trends** | Multi-month analytical spending visualization |
| **Transaction Browser** | Interactive complete transaction history view |

## Workflow

As a PhoenixClaw plugin, Ledger hooks into the `post-moment-analysis` phase:

1. **Receive Moments**: Get identified moments from PhoenixClaw Core
2. **Detect Finances**: Scan for expense/income signals in text and media
   - Text: Semantic patterns (see `references/expense-detection.md`)
   - Media: Payment screenshots (see `references/payment-screenshot.md`)
3. **Extract Data**: Parse amount, merchant, category, timestamp
4. **Categorize**: Apply rules from `references/merchant-category-map.md`
5. **Deduplicate**: Prevent double-counting same transaction
6. **Store**: Write to `~/PhoenixClaw/Finance/ledger.yaml`
7. **Export**: Generate journal section using `assets/daily-finance-section.md`

## Explicit Triggers

While passive by design, users can interact directly:

- *"How much did I spend today/this week/this month?"*
- *"Show my expense breakdown"*
- *"Set my monthly budget to [amount]"*
- *"What are my top spending categories?"*
- *"Generate financial report for [period]"*
- *"Set a savings goal for [amount] by [date]"*
- *"Show my spending trends"*
- *"Browse all my transactions"*
- *"How am I doing on my goals?"*

## Output Structure

```
~/PhoenixClaw/
├── Journal/
│   ├── daily/2026-02-02.md    # Contains 💰 Finance section
│   └── weekly/2026-W05.md     # Weekly financial recaps
│
└── Finance/                    # Ledger-specific directory
    ├── ledger.yaml             # Structured transaction data
    ├── budget.yaml             # Budget configuration
    ├── goals.yaml              # Financial goals tracking
    ├── transactions.md         # Transaction browser view
    ├── monthly/
    │   └── 2026-02.md          # Monthly financial reports
    └── yearly/
        └── 2026.md             # Annual summaries
```

## Configuration

Ledger-specific settings in `~/.phoenixclaw/config.yaml`:

```yaml
plugins:
  phoenixclaw-ledger:
    enabled: true
    default_currency: CNY       # or USD, EUR, etc.
    budget_monthly: 5000        # Monthly budget amount
    categories_custom: []       # User-defined categories
    screenshot_confidence: 0.7  # Min confidence for auto-record
```

## Cron & Scheduled Reports

Ledger uses PhoenixClaw Core's cron infrastructure plus additional scheduled tasks:

| Task | Schedule | Description |
|------|----------|-------------|
| **Daily Processing** | 10 PM (via Core) | Extracts transactions, generates daily section |
| **Monthly Report** | 1st of month, 8 AM | Comprehensive monthly financial summary |
| **Weekly Summary** | Sunday 9 PM (optional) | Weekly spending recap |

### Daily Processing (Automatic)

No separate setup required. Ledger hooks into Core's nightly cron:
- Core runs at 10 PM → triggers `post-moment-analysis`
- Ledger activates, extracts finances, exports to journal

### Monthly Report Setup

```bash
openclaw cron add \
  --name "PhoenixClaw Ledger monthly report" \
  --cron "0 8 1 * *" \
  --tz "auto" \
  --session isolated \
  --message "Generate monthly financial report for the previous month."
```

See `references/cron-setup.md` for full configuration details.

## Documentation Reference

### References (`references/`)
- `expense-detection.md`: Semantic patterns for conversation parsing
- `payment-screenshot.md`: Screenshot recognition and OCR extraction
- `merchant-category-map.md`: Merchant to category mapping rules
- `category-rules.md`: Category definitions and hierarchy
- `budget-tracking.md`: Budget alerts and progress calculation
- `financial-insights.md`: Pattern analysis for Growth Notes
- `cron-setup.md`: Scheduled tasks and report automation
- `goal-management.md`: Financial goals and progress tracking
- `query-patterns.md`: Natural language query templates and logic

### Assets (`assets/`)
- `expense-callout.md`: Template for conversation-detected expenses
- `receipt-callout.md`: Template for screenshot-detected expenses
- `daily-finance-section.md`: Journal integration template
- `monthly-report.md`: Monthly summary template
- `yearly-report.md`: Annual summary template

---
