# Routines and Reminders

## Setting Up Routines

Store in ~/pets/{pet}/routines.md:

```markdown
## Daily
- 07:00 — Morning walk (30 min)
- 07:30 — Breakfast (1 cup kibble + supplement)
- 12:00 — Midday potty break
- 18:00 — Dinner (1 cup kibble)
- 19:00 — Evening walk (45 min)
- 21:00 — Final potty break

## Weekly
- Sunday — Brush coat
- Wednesday — Nail check

## Monthly
- 1st — Flea/tick treatment
- 15th — Weigh-in
```

---

## Reminder Types

### Recurring Reminders
Set via cron jobs:
- **Daily:** Feeding, walks, medication
- **Weekly:** Grooming, training sessions
- **Monthly:** Flea treatment, food reorder, weigh-in
- **Yearly:** Vaccination due, license renewal

### One-Time Reminders
- Vet appointment on specific date
- Grooming booking
- Pet sitter confirmation
- Food delivery expected

### Smart Reminders
- "Remind me when it's time for Luna's flea treatment" → Calculate based on last application
- "Luna's food is running low" → Set reorder reminder based on consumption rate

---

## Multi-Pet Coordination

When household has multiple pets:
- Track who needs what when
- Flag conflicts (can't walk Dog A and Dog B together)
- Summarize daily schedule across all pets
- Note shared resources (same feeding time = separate bowls)

---

## Routine Optimization

Over time, suggest improvements:
- "Luna seems restless after 6pm walk — consider adding midday exercise"
- "Max's accidents happen before first walk — earlier schedule might help"
- "Both cats eat at different speeds — separate feeding locations recommended"

---

## Travel/Vacation Mode

When user traveling:
- Generate care instructions for pet sitter
- List all routines with details
- Emergency contacts and vet info
- Medication schedules if applicable
- Pet's quirks and preferences
