---
name: peter-bugfix-loop
description: 代码缺陷修复闭环。聚焦“先复现、再定位、最小修复、同上下文补测试”，并衔接现有 Peter 门禁与 PR 收口流程。
version: 1.0.0
---

# Peter Bugfix Loop

## 30 秒简介
用于“把一个 Bug 从问题描述推进到可合并修复”。

它聚焦 6 件事：
1. 建立可执行 Bug 卡
2. 先做最小复现（先红）
3. 假设驱动定位根因
4. 最小修复（控制 blast radius）
5. 同上下文补测试
6. 接入现有门禁与 PR 收口

## 适用场景
- 用户提到“修 bug”“定位回归”“线上缺陷修复”
- CI 失败怀疑是代码问题而非偶发波动
- 希望把修复过程沉淀成可复用步骤

## 执行步骤
1. 建立 Bug 卡（最小输入）
- 记录：现象、期望行为、影响范围、复现入口。
- 必须写一条可验证验收句（示例：`给定 A 输入，接口应返回 200；当前返回 500`）。

2. 最小复现（先红）
- 优先新增最小失败测试用例。
- 暂时无法写测时，至少保留 CLI/HTTP/页面复现脚本与命令。

3. 假设驱动定位
- 先列出 2-3 个候选根因。
- 只读取与路径相关代码，避免未定位时大面积重构。

4. 最小修复
- 只改根因相关文件与必要调用链。
- 顺手重构拆到后续独立 PR。

5. 同上下文补测试
- 非纯 UI 微调，必须补自动化测试。
- 至少覆盖：触发条件、边界输入、错误分支。

6. 接入现有 Peter 流程
- 提交前审查：`peter-code-review`
- 提交建 PR：`peter-commit-ops`
- CI 门禁：`peter-ci-gate`
- PR 收口：`peter-pr-ops`

## 输出格式（固定）
1. `## Bug 修复报告`
2. `### Bug 卡`（现象 / 期望 / 影响范围 / 验收句）
3. `### 复现与根因`（复现证据 / 候选根因 / 最终根因）
4. `### 修复与测试`（改动文件 / 新增或更新测试 / 本地结果）
5. `### 门禁与收口`（code-review 结论 / CI gate 状态 / PR 状态）
6. `### 结论`（`已修复可收口` / `需继续修复` / `阻塞`）

## 护栏
- 禁止“未复现先改代码”。
- 禁止把“CI 重跑成功”当作根因修复。
- 默认原子提交，不混入无关重构。
- 发现高风险回归时，优先回滚（revert PR）再补回归测试。
