---
slug: mbti-personality-test
name: MBTI Personality Test
description: Myers-Briggs Type Indicator test - 70 questions to determine your 4-letter personality type
user-invocable: true
---

# MBTI Personality Test

Take the Myers-Briggs Type Indicator (MBTI) personality test to discover your 4-letter personality type.

## Instructions

Read each question below and choose the option that best describes you. After answering all 70 questions, follow the scoring instructions to calculate your personality type.

Answer honestly based on how you actually are, not how you wish to be.

## The 70 Questions

Answer each question by choosing the option that best describes you. Record the **value** (letter in parentheses) for your choice.

**Q1.** At a party do you:
- **(e)** Interact with many, including strangers
- **(i)** Interact with a few, known to you

**Q2.** Are you more:
- **(s)** Realistic than speculative
- **(n)** Speculative than realistic

**Q3.** Is it worse to:
- **(s)** Have your "head in the clouds"
- **(n)** Be "in a rut"

**Q4.** Are you more impressed by:
- **(t)** Principles
- **(f)** Emotions

**Q5.** Are more drawn toward the:
- **(t)** Convincing
- **(f)** Touching

**Q6.** Do you prefer to work:
- **(j)** To deadlines
- **(p)** Just "whenever"

**Q7.** Do you tend to choose:
- **(j)** Rather carefully
- **(p)** Somewhat impulsively

**Q8.** At parties do you:
- **(e)** Stay late, with increasing energy
- **(i)** Leave early with decreased energy

**Q9.** Are you more attracted to:
- **(s)** Sensible people
- **(n)** Imaginative people

**Q10.** Are you more interested in:
- **(s)** What is actual
- **(n)** What is possible

**Q11.** In judging others are you more swayed by:
- **(t)** Laws than circumstances
- **(f)** Circumstances than laws

**Q12.** In approaching others is your inclination to be somewhat:
- **(t)** Objective
- **(f)** Personal

**Q13.** Are you more:
- **(j)** Punctual
- **(p)** Leisurely

**Q14.** Does it bother you more having things:
- **(j)** Incomplete
- **(p)** Completed

**Q15.** In your social groups do you:
- **(e)** Keep abreast of other's happenings
- **(i)** Get behind on the news

**Q16.** In doing ordinary things are you more likely to:
- **(s)** Do it the usual way
- **(n)** Do it your own way

**Q17.** Writers should:
- **(s)** Say what they mean and mean what they say
- **(n)** Express things more by use of analogy

**Q18.** Which appeals to you more:
- **(t)** Consistency of thought
- **(f)** Harmonious human relationships

**Q19.** Are you more comfortable in making:
- **(t)** Logical judgments
- **(f)** Value judgments

**Q20.** Do you want things:
- **(j)** Settled and decided
- **(p)** Unsettled and undecided

**Q21.** Would you say you are more:
- **(j)** Serious and determined
- **(p)** Easy-going

**Q22.** In phoning do you:
- **(e)** Rarely question that it will all be said
- **(i)** Rehearse what you'll say

**Q23.** Facts:
- **(s)** Speak for themselves
- **(n)** Illustrate principles

**Q24.** Are visionaries:
- **(s)** Somewhat annoying
- **(n)** Rather fascinating

**Q25.** Are you more often:
- **(t)** A cool-headed person
- **(f)** A warm-hearted person

**Q26.** Is it worse to be:
- **(t)** Unjust
- **(f)** Merciless

**Q27.** Should one usually let events occur:
- **(j)** By careful selection and choice
- **(p)** Randomly and by chance

**Q28.** Do you feel better about:
- **(j)** Having purchased
- **(p)** Having the option to buy

**Q29.** In company do you:
- **(e)** Initiate conversation
- **(i)** Wait to be approached

**Q30.** Common sense is:
- **(s)** Rarely questionable
- **(n)** Frequently questionable

**Q31.** Children often do not:
- **(s)** Make themselves useful enough
- **(n)** Exercise their fantasy enough

**Q32.** In making decisions do you feel more comfortable with:
- **(t)** Standards
- **(f)** Feelings

**Q33.** Are you more:
- **(t)** Firm than gentle
- **(f)** Gentle than firm

**Q34.** Which is more admirable:
- **(j)** The ability to organize and be methodical
- **(p)** The ability to adapt and make do

**Q35.** Do you put more value on:
- **(j)** Infinite
- **(p)** Open-minded

**Q36.** Does new and non-routine interaction:
- **(e)** Stimulate and energize you
- **(i)** Tax your reserves

**Q37.** Are you more frequently:
- **(s)** A practical sort of person
- **(n)** A fanciful sort of person

**Q38.** Are you more likely to:
- **(s)** See how others are useful
- **(n)** See how others see

**Q39.** Which is more satisfying:
- **(t)** To discuss an issue thoroughly
- **(f)** To arrive at agreement on an issue

**Q40.** Which rules you more:
- **(t)** Your head
- **(f)** Your heart

**Q41.** Are you more comfortable with work that:
- **(j)** Contracted
- **(p)** Done on a casual basis

**Q42.** Do you tend to look for:
- **(j)** The orderly
- **(p)** Whatever turns up

**Q43.** Do you prefer:
- **(e)** Many friends with brief contact
- **(i)** A few friends with more lengthy contact

**Q44.** Do you go more by:
- **(s)** Facts
- **(n)** Principles

**Q45.** Are you more interested in:
- **(s)** Production and distribution
- **(n)** Design and research

**Q46.** Which is more of a compliment:
- **(t)** "There is a very logical person."
- **(f)** "There is a very sentimental person."

**Q47.** Do you value in yourself more that you are:
- **(t)** Unwavering
- **(f)** Devoted

**Q48.** Do you more often prefer the:
- **(j)** Final and unalterable statement
- **(p)** Tentative and preliminary statement

**Q49.** Are you more comfortable:
- **(j)** After a decision
- **(p)** Before a decision

**Q50.** Do you:
- **(e)** Speak easily and at length with strangers
- **(i)** Find little to say to strangers

**Q51.** Are you more likely to trust your:
- **(s)** Experience
- **(n)** Hunch

**Q52.** Do you feel:
- **(s)** More practical than ingenious
- **(n)** More ingenious than practical

**Q53.** Which person is more to be complimented – one of:
- **(t)** Clear reason
- **(f)** Strong feeling

**Q54.** Are you inclined more to be:
- **(t)** Fair-minded
- **(f)** Sympathetic

**Q55.** Is it preferable mostly to:
- **(j)** Make sure things are arranged
- **(p)** Just let things happen

**Q56.** In relationships should most things be:
- **(j)** Re-negotiable
- **(p)** Random and circumstantial

**Q57.** When the phone rings do you:
- **(e)** Hasten to get to it first
- **(i)** Hope someone else will answer

**Q58.** Do you prize more in yourself:
- **(s)** A strong sense of reality
- **(n)** A vivid imagination

**Q59.** Are you drawn more to:
- **(s)** Fundamentals
- **(n)** Overtones

**Q60.** Which seems the greater error:
- **(t)** To be too passionate
- **(f)** To be too objective

**Q61.** Do you see yourself as basically:
- **(t)** Hard-headed
- **(f)** Soft-hearted

**Q62.** Which situation appeals to you more:
- **(j)** The structured and scheduled
- **(p)** The unstructured and unscheduled

**Q63.** Are you a person that is more:
- **(j)** Routinized than whimsical
- **(p)** Whimsical than routinized

**Q64.** Are you more inclined to be:
- **(e)** Easy to approach
- **(i)** Somewhat reserved

**Q65.** In writings do you prefer:
- **(s)** The more literal
- **(n)** The more figurative

**Q66.** Is it harder for you to:
- **(s)** Identify with others
- **(n)** Utilize others

**Q67.** Which do you wish more for yourself:
- **(t)** Clarity of reason
- **(f)** Strength of compassion

**Q68.** Which is the greater fault:
- **(t)** Being indiscriminate
- **(f)** Being critical

**Q69.** Do you prefer the:
- **(j)** Planned event
- **(p)** Unplanned event

**Q70.** Do you tend to be more:
- **(j)** Deliberate than spontaneous
- **(p)** Spontaneous than deliberate

---

## How to Score Your Results

After answering all 70 questions above, follow these steps:

### Step 1: Count Your Answers

Go through your 70 answers and count how many times you chose each letter:
- Count how many **e** and how many **i** (should total 10)
- Count how many **s** and how many **n** (should total 20)
- Count how many **t** and how many **f** (should total 20)
- Count how many **j** and how many **p** (should total 20)

### Step 2: Calculate Percentages

For each dimension, calculate the percentage:
- **E%** = (number of e ÷ 10) × 100, and **I%** = 100 - E%
- **S%** = (number of s ÷ 20) × 100, and **N%** = 100 - S%
- **T%** = (number of t ÷ 20) × 100, and **F%** = 100 - T%
- **J%** = (number of j ÷ 20) × 100, and **P%** = 100 - J%

### Step 3: Determine Your Type

For each dimension, choose the letter you scored higher on:
- **E or I**: Whichever has the higher count
- **S or N**: Whichever has the higher count
- **T or F**: Whichever has the higher count
- **J or P**: Whichever has the higher count

Combine these four letters in order to get your personality type.

**Example:** If you scored higher on I, N, T, and J, your type is **INTJ**

### Step 4: Display Your Results

Present your results in this format:

```
═══════════════════════════════════════════════════
MBTI PERSONALITY TEST RESULTS
═══════════════════════════════════════════════════

Your Type: [Your 4-letter type]
Description: [Description from list below]

Dimension Breakdown:
───────────────────────────────────────────────────
Extraversion (E)     XX%  |  XX%  Introversion (I)
Sensing (S)          XX%  |  XX%  Intuition (N)
Thinking (T)         XX%  |  XX%  Feeling (F)
Judging (J)          XX%  |  XX%  Perceiving (P)
═══════════════════════════════════════════════════
```

## The 16 Personality Types

### Analysts (NT)
- **INTJ** - The Architect: Strategic, analytical, independent thinker with high standards
- **INTP** - The Logician: Innovative, curious, theoretical problem-solver
- **ENTJ** - The Commander: Bold, strategic leader who enjoys organizing and planning
- **ENTP** - The Debater: Quick-witted, innovative, loves intellectual challenges

### Diplomats (NF)
- **INFJ** - The Advocate: Idealistic, organized, insightful with strong values
- **INFP** - The Mediator: Thoughtful, idealistic, driven by values and beliefs
- **ENFJ** - The Protagonist: Charismatic, inspiring leader focused on helping others
- **ENFP** - The Campaigner: Enthusiastic, creative, sociable free spirit

### Sentinels (SJ)
- **ISTJ** - The Logistician: Practical, fact-minded, reliable organizer
- **ISFJ** - The Defender: Dedicated, warm protector with strong sense of duty
- **ESTJ** - The Executive: Organized, practical administrator who values tradition
- **ESFJ** - The Consul: Caring, social, popular with strong sense of duty

### Explorers (SP)
- **ISTP** - The Virtuoso: Bold, practical experimenter and master of tools
- **ISFP** - The Adventurer: Flexible, charming artist who explores life
- **ESTP** - The Entrepreneur: Energetic, perceptive, lives in the moment
- **ESFP** - The Entertainer: Spontaneous, enthusiastic, loves being center stage

---

## Complete the Assessment

Now that you understand the process, complete your MBTI personality test:

1. Go through all 70 questions above
2. For each question, choose the option that best describes you (record the letter in parentheses)
3. Count how many times you selected each letter (e, i, s, n, t, f, j, p)
4. Calculate the percentages for each dimension
5. Determine your 4-letter personality type
6. Display your results using the format shown above

Take your time and answer honestly.
