# Domain Expertise Layer

## Philosophy

"Agents search excellently but they don't understand."

A search agent collects every review, spec sheet, and price. But it can't tell you: "this spec doesn't matter for your use case" or "the difference on paper doesn't translate to real-world impact." That's the expertise layer's job.

The expertise layer does NOT search. It receives search results and passes judgment.

## Agent 5: The Expert — 5 Critical Questions

### 1. Do the specs serve the actual use case?

Example: A microphone with 192kHz sample rate. Impressive on paper. But podcasting doesn't need more than 48kHz. That spec is overkill and irrelevant to the purchase decision.

### 2. What's the real difference between options?

Not the spec sheet difference — the difference the user actually feels. Sometimes a $500 gap between products translates to a marginal real-world improvement only visible under lab conditions.

### 3. Are any specs overkill?

Excess capability = paying for unused performance. "Better" isn't always "best fit." A 4K 144Hz monitor is wasted on someone who only does spreadsheets and email.

### 4. What do reviews typically miss?

Reviewers focus on measurable specs. But real-world factors matter more:
- Ease of setup and daily use
- Companion software/app quality
- Spare parts availability
- Community support size
- Ecosystem lock-in implications
- Resale value trajectory
- Noise/heat/power consumption in real conditions

### 5. If buying for yourself, what would you choose and why?

The most important question. Forces the expert to commit. Not a neutral analysis — a personal decision with reasoning. This is what kills doubt.

## Agent 6: Latest Tech Search Strategies

| Strategy | Application |
|----------|-------------|
| Time-bound search | Restrict to last 6 months |
| Launch keywords | "announced", "launched", "new", "2025", "2026", "upcoming" |
| Trade shows | CES, MWC, IFA + product category |
| New arrivals | "New" pages on official brand websites |
| Generation comparison | "{product} gen 2 vs gen 1", "worth upgrading" |
| Discontinuation check | "{product} discontinued", "{product} end of life" |

## Priority Rule: Expert Overrides Latest Tech

When Agent 5 and Agent 6 conflict, the Expert's judgment wins.

**Reason:** Agent 6 focuses on "what's new" by nature. "New" ≠ "better." The Expert understands when the current generation is sufficient.

**Exception:** Factual discoveries override expert opinion:
- Product being discontinued → fact, not judgment
- New generation launching within weeks at the same price → fact
- Critical flaw discovered in recommended product → fact

## Real-World Examples

### Success: Maono PD200X vs Shure MV7+

**Context:** USB microphone for podcasting. Open budget.

**Search results:** Every source recommended Shure MV7+ (~$250).

**Anti-Bias (Agent 2):** Discovered Maono PD200X. Dynamic USB/XLR mic with similar specs.

**Expert (Agent 5):**
- Audio specs comparable for podcasting
- Shure has better companion software (ShurePlus MOTIV)
- For beginner podcasting, audio difference is imperceptible
- PD200X has USB+XLR, so upgrade path exists

**Price:** Shure MV7+ ~$250 vs Maono PD200X ~$79.

**ADR Result:**
- Best Value: Maono PD200X — 73% cheaper, 90% of the quality
- Near-Pro: Shure MV7+ — premium build, better software, brand confidence
- Budget Killer: Fifine K688 — $59, surprisingly capable for the price

### Failure Caught: Boom Arm (Maono BA92 vs Rode PSA1+)

**Anti-Bias found:** Maono BA92 at ~$95 vs Rode PSA1+ at ~$100.

**Expert verdict:** Only $5 difference. Rode has proven build quality and warranty. Not worth the risk for negligible savings.

**Lesson:** Anti-bias doesn't always find a better alternative. Honesty > forced diversity.

### Success: iPhone Air vs iPhone Pro

**Context:** New phone for casual photography and social media.

**Search results:** Every source recommended iPhone 16 Pro or Samsung S24 Ultra.

**Expert (Agent 5):**
- For casual photography/social, Pro features are overkill
- Standard camera is perfectly adequate for Instagram/TikTok
- Real difference only shows in RAW, ProRes, Macro

**Latest Tech (Agent 6):** iPhone Air announced — thinner, lighter, adequate specs.

**Result:** iPhone Air recommended. Same brand, right model. Value from matching specs to needs.

**Lesson:** Sometimes the answer isn't "different brand" but "different model, same brand."
