# Anti-Bias Playbook

## Why Normal Search Returns the Same Results

| Bias | Description |
|------|-------------|
| Survivorship Bias | Popular products get more reviews → rank higher → get more reviews. Closed loop. |
| Echo Chamber | Same reviewers review the same products. Wirecutter → Reddit → YouTube → LLM. |
| LLM Training Bias | AI models trained on repeated content reflect the same bubble. |
| Affiliate Bias | Higher commission = more promotion, regardless of quality. |
| Regional Bias | English-language results dominate; products popular in Asia/Europe get overlooked. |

## The 6 Reverse Search Strategies

| # | Strategy | Method | Example |
|---|----------|--------|---------|
| 1 | Negative Search | Search for flaws in popular products | "Shure MV7 problems podcast", "why I returned {product}" |
| 2 | Brand Alternatives | Search lesser-known brands by name | "USB microphone Maono", "USB microphone Fifine" |
| 3 | Origin-Based | Search by country of origin | "best headphones Chinese audiophile", "best keyboard Korean" |
| 4 | Price-Point | Search by price, not brand | "best microphone under 200 SAR", "best laptop under 3000 SAR" |
| 5 | Professional Community | Search what professionals actually use | "what podcasters actually use microphone reddit" |
| 6 | Non-English | Search in other languages | Arabic, Japanese, Korean, German product reviews |

**Critical Rule:** The goal is to EXPAND the horizon, not exclude popular options. If reverse search confirms the popular product is genuinely the best, that's a valid and valuable result. Say so.

## Red Flags in Reviews

| Flag | Description | Detection |
|------|-------------|-----------|
| Sponsored Content | Paid review disguised as genuine | Check disclosure, count affiliate links, note if any negatives mentioned |
| Echo Chamber | All sources trace to one original review | Track primary source; if all cite Wirecutter, that's 1 source not 3 |
| Upselling | Always pushes the most expensive option | "The best" is always the priciest without technical justification |
| Affiliate Bias | Rankings reflect commission rates | High-commission products consistently placed first |
| Honeymoon Reviews | All reviews from the first month | No long-term reliability data; initial excitement skews |
| Astroturfing | Fake grassroots enthusiasm | Sudden flood of positive reviews, similar language patterns |

## Evaluating Unknown Brands

### Quick Check (5 minutes)

1. Official website with clear company information?
2. Company age (LinkedIn, Crunchbase)
3. Reddit search: "{brand} review" — real users?
4. Amazon reviews: read the 3-star reviews (most honest)
5. Support: "{brand} warranty", "{brand} customer service"

### Deep Check (15 minutes)

1. Find the actual manufacturer (many brands = same OEM factory)
2. Compare actual technical specs vs. marketing specs
3. Teardown or disassembly videos
4. Brand's product history (first product or established line?)
5. Authorized local distributor?

### Trust Matrix

| Signal | Trust | Action |
|--------|-------|--------|
| Real users praise it after 6+ months | High | Consider it |
| Track record in category (not first product) | High | Consider it |
| Clear warranty + reachable support | High | Consider it |
| 30%+ cheaper than known brand with similar specs | Worth investigating | Deep check |
| All reviews < 1 month old | Low | Honeymoon risk |
| No local distributor, no warranty | Low | Avoid unless massive savings |
| Price close to known brand | Low value | Why take the risk? |
| No successful prior products | Low | Avoid |

## Anti-Bias in Multi-Agent Context

Agent 2 (Anti-Bias) intentionally searches differently from Agent 1 (Mainstream). If both converge on the same product independently, that's the strongest possible signal — two different methodologies reaching the same conclusion.

If Agent 2 finds genuinely better alternatives, they get equal consideration in convergence. Agent 2's findings are not automatically "better" — they're a second opinion that expands the search space.

## Saudi Market Anti-Bias Notes

- Many "new brands" on Amazon.sa are Chinese OEM products with thin branding
- Jarir's house-brand accessories are often rebranded OEM at premium prices
- noon "noon picks" can reflect commercial arrangements, not quality curation
- Check if the "brand" has a presence outside Amazon (website, social media, support)
- Arabic YouTube reviewers sometimes have undisclosed sponsorships — cross-reference
