# DNA Testing Privacy Guide

## Privacy-Respecting Services

| Service | Privacy Level | Notes |
|---------|---------------|-------|
| **Nebula Genomics** | High | Blockchain consent, you control access |
| **Dante Labs** | High | EU-based (GDPR), WGS available |
| **Sequencing.com** | Medium-High | Accepts uploads, minimal retention |
| **Clinical labs** | High | Medical record protection, no consumer ToS |

## Services with Privacy Concerns

- **23andMe, Ancestry** — Broad ToS, pharma partnerships, law enforcement access, data breaches have occurred
- **Free tests** — You're the product

## Best Practices

1. Use pseudonym + dedicated email if allowed
2. Skip social features ("DNA relatives")
3. Download raw data immediately
4. Request deletion after download
5. Read data sharing terms before testing

## Already Tested?

Download your raw data and use local tools like this one. No need to share with another service.

---

*Your DNA is permanent. Choose carefully.*
