# Exercise Database

## Dumbbell Exercises

### Chest
| Exercise | Primary Muscles | Equipment | Notes |
|----------|----------------|-----------|-------|
| Dumbbell Bench Press | Chest, Front Delts, Triceps | Flat bench + DB | Staple chest builder |
| Dumbbell Fly | Chest | Flat bench + DB | Stretch focus, lighter weight |
| Incline DB Press | Upper Chest, Front Delts | Incline bench + DB | 30-45° angle ideal |
| Incline DB Fly | Upper Chest | Incline bench + DB | Upper chest stretch |
| Floor Press | Chest, Triceps | Floor + DB | Limited range, shoulder-friendly |
| Svend Press | Chest | 1 DB or plate | Squeeze focus, finisher |

### Back
| Exercise | Primary Muscles | Equipment | Notes |
|----------|----------------|-----------|-------|
| Dumbbell Row | Lats, Rhomboids, Rear Delts | Bench + DB | One arm, squeeze at top |
| Renegade Row | Lats, Core | Floor + 2 DB | Plank position, anti-rotation |
| Romanian Deadlift | Hamstrings, Lower Back, Glutes | 2 DB | Hip hinge, flat back |
| Stiff Leg Deadlift | Hamstrings, Lower Back | 2 DB | Knees nearly locked |
| Shrugs | Traps | 2 DB | Hold squeeze at top |
| Pullover | Lats, Chest | Bench + 1 DB | Stretch lats, controlled |

### Shoulders
| Exercise | Primary Muscles | Equipment | Notes |
|----------|----------------|-----------|-------|
| Overhead Press | Front/Side Delts, Triceps | 2 DB | Standing or seated |
| Arnold Press | All delt heads | 2 DB | Rotate wrists during press |
| Lateral Raise | Side Delts | 2 DB | Light weight, controlled |
| Front Raise | Front Delts | 2 DB | Alternate or together |
| Rear Delt Fly | Rear Delts | Bench or bent over | Light weight, squeeze |
| Upright Row | Traps, Delts | 2 DB | Don't pull too high |

### Arms
| Exercise | Primary Muscles | Equipment | Notes |
|----------|----------------|-----------|-------|
| Bicep Curl | Biceps | 2 DB | Full range, no swing |
| Hammer Curl | Biceps, Brachialis | 2 DB | Neutral grip |
| Incline Curl | Biceps (long head) | Incline bench | Deep stretch |
| Concentration Curl | Biceps | 1 DB | Elbow against inner thigh |
| Overhead Tricep Extension | Triceps | 1 heavy DB | Both hands, controlled |
| Tricep Kickback | Triceps | Bench + DB | Squeeze at extension |
| Skull Crusher | Triceps | Bench + DB | Keep elbows steady |
| Close Grip Floor Press | Triceps, Chest | Floor + DB | Elbows tucked |

### Legs
| Exercise | Primary Muscles | Equipment | Notes |
|----------|----------------|-----------|-------|
| Goblet Squat | Quads, Glutes | 1 heavy DB | Hold at chest |
| Dumbbell Squat | Quads, Glutes | 2 DB at sides | Keep chest up |
| Bulgarian Split Squat | Quads, Glutes | Bench + DB | Rear foot elevated |
| Lunge | Quads, Glutes, Hamstrings | 2 DB | Forward or walking |
| Romanian Deadlift | Hamstrings, Glutes | 2 DB | Hip hinge pattern |
| Calf Raise | Calves | 2 DB + platform | Full stretch at bottom |
| Step Up | Quads, Glutes | Bench + DB | Drive through heel |

## Bodyweight Exercises

### Push
| Exercise | Difficulty | Primary Muscles | Progression |
|----------|-----------|-----------------|-------------|
| Push-up | Beginner | Chest, Front Delts, Triceps | Knee → Standard → Diamond |
| Diamond Push-up | Intermediate | Triceps, Chest | Close hands under chest |
| Pike Push-up | Intermediate | Shoulders | Butt high, head to floor |
| Decline Push-up | Intermediate | Upper Chest | Feet elevated |
| Archer Push-up | Advanced | Chest (one side focus) | Extend one arm |
| Handstand Push-up | Advanced | Shoulders | Wall assisted |

### Pull
| Exercise | Difficulty | Primary Muscles | Notes |
|----------|-----------|-----------------|-------|
| Doorway Row | Beginner | Back, Biceps | Towel over door |
| Superman | Beginner | Lower Back | Hold squeeze |
| Prone Cobras | Beginner | Rear Delts, Upper Back | Chest on floor |
| Inverted Row | Intermediate | Back, Biceps | Table or low bar |

### Legs
| Exercise | Difficulty | Primary Muscles | Notes |
|----------|-----------|-----------------|-------|
| Bodyweight Squat | Beginner | Quads, Glutes | Full depth |
| Jump Squat | Intermediate | Quads, Power | Explosive |
| Bulgarian Split Squat | Intermediate | Quads, Glutes | Rear foot on chair |
| Walking Lunge | Intermediate | Quads, Glutes | Step forward |
| Step Up | Beginner | Quads, Glutes | Chair or stairs |
| Glute Bridge | Beginner | Glutes, Hamstrings | Squeeze at top |
| Single Leg RDL | Intermediate | Hamstrings | Balance challenge |
| Calf Raise | Beginner | Calves | Edge of step |

### Core
| Exercise | Difficulty | Target | Notes |
|----------|-----------|--------|-------|
| Plank | Beginner | Full Core | Straight line |
| Side Plank | Beginner | Obliques | Hip up |
| Dead Bug | Beginner | Core stability | Opposite arm/leg |
| Bird Dog | Beginner | Core, Back | Balance |
| Mountain Climber | Intermediate | Core, Cardio | Knees to chest |
| Leg Raise | Intermediate | Lower Abs | Controlled |
| Russian Twist | Intermediate | Obliques | Feet off ground |
| Bicycle Crunch | Intermediate | Full Core | Elbow to knee |

## Volume Guidelines

### Beginner (0-6 months)
- Sets per muscle per week: 10-12
- Reps per set: 8-12
- Rest between sets: 60-90 sec

### Intermediate (6-12 months)
- Sets per muscle per week: 12-16
- Reps per set: 6-12 (vary)
- Rest between sets: 90-120 sec

### Advanced (12+ months)
- Sets per muscle per week: 16-20+
- Reps per set: Vary (strength 3-6, hypertrophy 8-12, endurance 15+)
- Rest between sets: 2-3 min (compound), 60-90 sec (isolation)

## Progressive Overload Methods
1. Add weight
2. Add reps
3. Add sets
4. Reduce rest time
5. Improve form/range of motion
6. Increase frequency
