# Persona Doc Template

Use this template to create persona documentation. Replace bracketed placeholders with actual content. Delete sections that don't apply, but try to cover each area even briefly.

---

# [Product Name] - Persona Documentation

## Target User

**Who they are:** [Role, job title, or description - e.g., "Solo developers building side projects", "Marketing managers at mid-size companies"]

**Background:** [Their technical level, industry, typical workday]

**Context:** [When/where they'd use this product - at work, on mobile, during specific tasks]

## Problems Solved

**Pain points:**
- [Problem 1 - what frustrates them today]
- [Problem 2 - what takes too long or is too hard]
- [Problem 3 - what they wish existed]

**Why existing solutions fail:** [What alternatives exist and why they're insufficient]

## Discovery

**How they find us:**
- [Channel 1 - e.g., "Google search for [problem]"]
- [Channel 2 - e.g., "Recommendation from colleague"]
- [Channel 3 - e.g., "Blog post about [topic]"]

**What convinces them to try:** [The hook - what makes them click "sign up" or "download"]

## Onboarding

**First encounter:** [Landing page, app store, GitHub README - what do they see first]

**Registration/Login:** [Simplest viable auth - email-only? OAuth? No account needed?]

**Time to value:** [How quickly can they experience the core benefit - seconds, minutes, days?]

**First success moment:** [The specific action that makes them think "this is useful"]

Example:
> User lands on homepage → clicks "Try it" → pastes their data → sees result in <30 seconds → decides to create account

## User Journey

### New User (Day 1)
- Discovers product via [channel]
- [First action]
- [Second action]
- Achieves [first success]

### Returning User (Week 1)
- [Key repeated action]
- [Feature they explore]
- [Integration or customization]

### Power User (Month 1+)
- [Advanced features used]
- [Workflows established]
- [How they'd describe product to others]

## Feature Touchpoints

Map where users encounter key features:

| Feature | When Encountered | User Need at That Moment |
|---------|------------------|--------------------------|
| [Feature 1] | [Journey stage] | [What they're trying to do] |
| [Feature 2] | [Journey stage] | [What they're trying to do] |

---

## Tips

- **Start minimal**: A few sentences per section beats an empty doc
- **Be specific**: "Developers" is too broad; "Backend engineers debugging production issues" is useful
- **Update often**: Revisit as you learn more about actual users
- **One persona first**: If you have multiple user types, document the primary one first
