# Persona Docs

Create user-centered documentation that defines who a product is for and how they interact with it. Persona docs establish the foundation for product-driven development — every feature decision, design choice, and prioritization call flows from understanding your users.

## What's Inside

- Core components: Target User Profile, User Needs and Pain Points, Discovery Path, Onboarding Flow, User Journey Map, Feature Touchpoints
- Process for analyzing codebases and asking clarifying questions
- Multi-persona product guidance (primary vs secondary personas, conflict resolution)
- Quality criteria for effective persona documentation
- Template reference file for full structure
- Output location conventions

## When to Use

- Creating persona docs or documenting target users
- Defining user journeys or onboarding flows
- Starting a new product and needing to define its audience
- Before major feature planning to validate features serve actual users
- New team member onboarding for user context

## Installation

```bash
npx add https://github.com/wpank/ai/tree/main/skills/writing/persona-docs
```

### OpenClaw / Moltbot / Clawbot

```bash
npx clawhub@latest install persona-docs
```

### Manual Installation

#### Cursor (per-project)

From your project root:

```bash
mkdir -p .cursor/skills
cp -r ~/.ai-skills/skills/writing/persona-docs .cursor/skills/persona-docs
```

#### Cursor (global)

```bash
mkdir -p ~/.cursor/skills
cp -r ~/.ai-skills/skills/writing/persona-docs ~/.cursor/skills/persona-docs
```

#### Claude Code (per-project)

From your project root:

```bash
mkdir -p .claude/skills
cp -r ~/.ai-skills/skills/writing/persona-docs .claude/skills/persona-docs
```

#### Claude Code (global)

```bash
mkdir -p ~/.claude/skills
cp -r ~/.ai-skills/skills/writing/persona-docs ~/.claude/skills/persona-docs
```

## Related Skills

- **game-changing-features** — Use personas to inform high-leverage feature decisions
- **brainstorming** — Explore ideas with persona context in mind

---

Part of the [Writing](..) skill category.
