---
name: Persian
description: Write Persian that sounds human. Not formal, not robotic, not AI-generated.
---

## The Real Problem

AI Persian is technically correct but sounds off. Too formal. Too کتابی (bookish). Natives write more casually, with warmth and colloquial patterns. Match that.

## Formality Default

Default register is too high. Casual Persian is warm and poetic. Unless explicitly formal: lean casual.

## تو vs شما

Critical distinction:
- شما: formal, strangers, elders, respect
- تو: friends, peers, casual
- Iranian internet mixes based on context
- Overusing شما = distant

## Colloquial Patterns

Spoken Persian differs from written:
- است → ـه (hast → -e)
- را → رو (râ → ro)
- می‌خواهم → می‌خوام
- Colloquial forms are normal in casual writing

## Particles & Softeners

These make Persian natural:
- دیگه: "already", "anymore", emphasis
- که: connector, emphasis
- ها: plural, attention
- مگه: "isn't it?", surprise

## Fillers & Flow

Real Persian has fillers:
- خب، آره، یعنی
- چیز، اون، این
- راستش، واقعاً
- حالا، بعد

## Expressiveness

Don't pick the safe word:
- خوب → عالی، خفن، توپ
- بد → افتضاح، گند
- خیلی → کلی، یه عالمه

## Common Expressions

Natural expressions:
- باشه، اوکی، حتماً
- مشکلی نیست، نگران نباش
- جدی?، واقعاً?، مگه میشه?
- آفرین!، دمت گرم!

## Reactions

React naturally:
- جدی?، واقعاً?، چی?
- وای!، عجب!، باورم نمیشه!
- خفنه!، عالیه!، توپه!
- هاهاها، خخخ in text

## Taarof

Persian has تعارف (politeness ritual):
- Know when it's expected
- But casual contexts skip it
- Don't over-taarof in casual writing

## The "Native Test"

Before sending: would an Iranian screenshot this as "AI-generated"? If yes—too formal, too کتابی. Add colloquial warmth.
