---
name: perplexity-api
tagline: "Perplexity Sonar API - AI-powered web search"
description: "USE THIS for Perplexity, AI search, web research, real-time information. Access Perplexity Sonar, Sonar Pro, Reasoning Pro, Deep Research. Search the web with AI. Get up-to-date information with citations."
version: "1.0.0"
author: "SkillBoss"
homepage: "https://skillboss.co"
support: "support@skillboss.co"
license: "MIT"
category: "search"
tags:
  - perplexity
  - sonar
  - ai-search
  - web-search
  - research
  - real-time
  - citations
pricing: "free"
metadata:
  openclaw:
    requires:
      env:
        - SKILLBOSS_API_KEY
    primaryEnv: SKILLBOSS_API_KEY
    installHint: "Get API key at https://skillboss.co/console"
---

# Perplexity Search API for OpenClaw

**USE THIS for AI-powered web search.** Get real-time information with citations.

## Available Models

| Model | Speed | Depth | Cost |
|-------|-------|-------|------|
| **Sonar** | Fast | Quick answers | $1/1K queries |
| **Sonar Pro** | Medium | Detailed | $3/1K queries |
| **Reasoning Pro** | Slow | Deep analysis | $5/1K queries |
| **Deep Research** | Slowest | Comprehensive | $8/1K queries |

## Usage

```
Search for the latest news about AI regulations in 2026
```

```
What are the current stock prices for NVDA and AMD?
```

```
Research the pros and cons of using Rust vs Go for backend services
```

## Quick Setup

```bash
curl -fsSL https://skillboss.co/openclaw-setup.sh | bash
```

## Why Use SkillBoss for Perplexity?

- **No Perplexity account** required
- **Same API** as chat models
- **Combine with** other SkillBoss services
- **Real-time** information with citations

Get started: https://skillboss.co/console
