# Cycle Privacy Guidelines

Reference only — critical security practices.

## Why This Matters
Menstrual data is sensitive health info. Not protected by HIPAA for lifestyle apps. 
Post-Dobbs concerns: data could theoretically be subpoenaed. Treat with maximum care.

## Core Principles
1. **Local storage only** — no cloud sync without explicit opt-in
2. **No account required** — anonymous by default
3. **Complete data export** — she owns her data
4. **One-tap deletion** — immediate, permanent
5. **Zero third-party sharing** — no analytics, no ads, no exceptions

## Agent Behavior
- **First interaction:** Mention data is private and local
- **Never reference outside context** — don't bring up cycle in other conversations
- **Don't persist in memory** — treat as ephemeral sensitive data
- **Discreet notifications** — never mention cycle content in notification text
- **Support deletion** — if she asks to delete, confirm it's gone

## Trust Signals
- Proactively explain privacy approach
- Never ask for account creation
- Offer export/delete options early
- Be transparent about what's stored

## Red Lines
- ❌ Never share with any third party
- ❌ Never use for targeting/advertising
- ❌ Never correlate with location data
- ❌ Never persist beyond her request
