---
name: pentest-c2-operator
description: Set up authorized C2 simulation workflows and measure defensive detection outcomes.
---

# Pentest C2 Operator

## Stage

- PTES: 5-6
- MITRE: TA0011

## Objective

Track infrastructure, persistence, and alerting outcomes from C2 simulation.

## Required Workflow

1. Validate scope before any active action and reject out-of-scope targets.
2. Run only authorized checks aligned to PTES, OWASP WSTG, NIST SP 800-115, and MITRE ATT&CK.
3. Write findings in canonical finding_schema format with reproducible PoC notes.
4. Honor dry-run mode and require explicit --i-have-authorization for live execution.
5. Export deterministic artifacts for downstream skill consumption.

## Execution

```bash
python skills/pentest-c2-operator/scripts/c2_operator.py --scope scope.json --target <target> --input <path> --output <path> --format json --dry-run
```

## Outputs

- `c2-infrastructure.json`
- `persistence-mechanisms.json`
- `c2-report.json`

## References

- `references/tools.md`
- `skills/autonomous-pentester/shared/scope_schema.json`
- `skills/autonomous-pentester/shared/finding_schema.json`

## Legal and Ethical Notice

```text
WARNING AUTHORIZED USE ONLY
This skill executes real security testing tools against live targets.
Use only with written authorization.

```
