---
name: pentest-auth-bypass
description: Test authentication and session management controls for bypass and account takeover scenarios.
---

# Pentest Auth Bypass

## Stage

- PTES: 5
- MITRE: T1110, T1550

## Objective

Validate brute-force resistance, session integrity, and MFA enforcement.

## Required Workflow

1. Validate scope before any active action and reject out-of-scope targets.
2. Run only authorized checks aligned to PTES, OWASP WSTG, NIST SP 800-115, and MITRE ATT&CK.
3. Write findings in canonical finding_schema format with reproducible PoC notes.
4. Honor dry-run mode and require explicit --i-have-authorization for live execution.
5. Export deterministic artifacts for downstream skill consumption.

## Execution

```bash
python skills/pentest-auth-bypass/scripts/auth_bypass.py --scope scope.json --target <target> --input <path> --output <path> --format json --dry-run
```

## Outputs

- `auth-findings.json`
- `valid-sessions.json`
- `auth-attack-report.json`

## References

- `references/tools.md`
- `skills/autonomous-pentester/shared/scope_schema.json`
- `skills/autonomous-pentester/shared/finding_schema.json`

## Legal and Ethical Notice

```text
WARNING AUTHORIZED USE ONLY
This skill executes real security testing tools against live targets.
Use only with written authorization.

```
