---
name: pentest-api-attacker
description: Test APIs against OWASP API Security Top 10 including discovery, auth abuse, and protocol-specific checks.
---

# Pentest API Attacker

## Stage

- PTES: 5
- MITRE: T1190

## Objective

Enumerate and test API endpoints and business logic attack vectors.

## Required Workflow

1. Validate scope before any active action and reject out-of-scope targets.
2. Run only authorized checks aligned to PTES, OWASP WSTG, NIST SP 800-115, and MITRE ATT&CK.
3. Write findings in canonical finding_schema format with reproducible PoC notes.
4. Honor dry-run mode and require explicit --i-have-authorization for live execution.
5. Export deterministic artifacts for downstream skill consumption.

## Execution

```bash
python skills/pentest-api-attacker/scripts/api_attacker.py --scope scope.json --target <target> --input <path> --output <path> --format json --dry-run
```

## Outputs

- `api-endpoints.json`
- `api-findings.json`
- `api-attack-report.json`

## References

- `references/tools.md`
- `skills/autonomous-pentester/shared/scope_schema.json`
- `skills/autonomous-pentester/shared/finding_schema.json`

## Legal and Ethical Notice

```text
WARNING AUTHORIZED USE ONLY
This skill executes real security testing tools against live targets.
Use only with written authorization.

```
