# 연금/노후 플레이북

> 공통 Phase 구조: [`../common/playbook_base.md`](../common/playbook_base.md)

---

## Phase 1: 인텐트 분류 & 파라미터 확인

1. 사용자 요청을 [`references/intent_router.md`](references/intent_router.md)로 분류
2. **핵심 파라미터**:
   - **Pension Estimate**: 나이 + 평균 소득 (없으면 평균임금 350만원 기본값)
   - **Retirement Sim / FIRE**: 목표 월 생활비 또는 목표 은퇴 나이
   - **Severance Pay**: 근속 연수 + 최근 3개월 평균 임금
3. 파라미터 부족 시:
   ```
   예: "현재 나이와 국민연금 가입 기간(대략이라도)을 알려주시면 계산해드릴게요"
   예: "은퇴 후 월 생활비 목표가 얼마인지 알려주시면 필요 자산을 계산해드릴게요"
   ```

---

## Phase 2: 데이터 수집

### 2-1. 국민연금 예상액 → 내장 계산식 (API 보조)
내장 계산식으로 즉시 계산. API는 가입 이력 상세 조회 시 활용.
```bash
# 키 활성화 후 사용
# bash skills/pension-guide/scripts/nps_query.sh "[주민번호 앞자리]"
```

### 2-2. 연금펀드/ETF 수익률 → yahoo-finance 연계
```bash
~/.npm-global/bin/yf quote 069500.KS  # KODEX 200 (연금펀드 벤치마크)
~/.npm-global/bin/yf quote 360750.KS  # TIGER 미국S&P500
```

### 2-3. 최신 세제 정보 → 웹 검색
```
web_search: "IRP 연금저축 세액공제 한도 2025"
web_search: "국민연금 소득대체율 2025"
```

---

## Phase 3: 핵심 계산식

### 국민연금 예상 수령액 계산 (간이식)
```
기본연금액 = 1.485 × (A + B) × (1 + 0.05n/12)

A = 전체 가입자 최근 3년 평균 소득 (2025년 기준: 약 286만원)
B = 본인 가입 기간 전체 평균 소득
n = 20년 초과 가입 월수

※ 20년 납부 기준 소득대체율 약 40%
※ 40년 납부 기준 소득대체율 약 40%(법정) → 실질 약 50%
```

**간편 추정 (20년 납부, 월 소득 X만원)**
| 평균 소득 | 20년 납부 | 30년 납부 | 40년 납부 |
|---------|---------|---------|---------|
| 200만원 | 약 40만원 | 약 55만원 | 약 70만원 |
| 300만원 | 약 55만원 | 약 75만원 | 약 95만원 |
| 400만원 | 약 70만원 | 약 95만원 | 약 120만원 |
| 500만원 | 약 80만원 | 약 110만원 | 약 140만원 |

### 퇴직금 계산 (근로자퇴직급여보장법)
```
퇴직금 = 평균임금 × 30일 × (근속연수)

평균임금 = 퇴직 전 3개월 총 급여 / 해당 기간 일수
※ 1년 미만이면 비례 계산
```

**퇴직소득세 (2025년 기준)**
| 근속 연수 | 공제액 |
|---------|------|
| 5년 이하 | 근속연수 × 30만원 |
| 10년 이하 | 150만원 + (근속연수 - 5) × 50만원 |
| 20년 이하 | 400만원 + (근속연수 - 10) × 80만원 |
| 20년 초과 | 1,200만원 + (근속연수 - 20) × 120만원 |

### FIRE 계산 (4% / 3.5% 룰)
```
필요 자산 = 연간 생활비 × 25  (4% 룰)
필요 자산 = 연간 생활비 × 28.6  (3.5% 룰, 한국 권장)

달성 기간 = log(목표자산 / 현재자산) / log(1 + 연수익률)
```

### 기초연금 수급 조건 (2025년)
- 만 65세 이상
- 소득인정액 기준 이하 (단독: 약 213만원/월, 부부: 약 340만원/월)
- 급여액: 최대 월 33만 4,810원 (단독, 2025년)
- 국민연금 수령액에 따라 감액 가능

### IRP/연금저축 세액공제 한도 (2025년)
| 소득 구간 | 공제율 | IRP+연금저축 한도 | 최대 공제액 |
|---------|------|--------------|---------|
| 5,500만원 이하 | 16.5% | 900만원 | 148.5만원 |
| 5,500만원 초과 | 13.2% | 900만원 | 118.8만원 |

---

## Phase 4: 출력

[`references/output_templates.md`](references/output_templates.md) 적용.

**Retirement Portfolio 인텐트**: finance-portfolio-counseling 스킬 위임
```
→ "은퇴 포트폴리오는 finance-portfolio-counseling 스킬이 전문이에요.
   나이와 은퇴까지 남은 기간을 알려주시면 맞춤 포트폴리오를 짜드릴게요!"
```

### 면책 문구 (모든 응답 필수)
> ⚠️ 본 내용은 정보 제공 목적이며, 투자·재무 조언이 아닙니다.
> 국민연금 정확한 예상액은 [내연금](https://csa.nps.or.kr)에서 확인하세요.
