# Response Templates for Peer Review Letters

This document provides templates for common response scenarios in academic peer review correspondence.

## General Principles

1. **Always express gratitude** - Even for critical comments
2. **Be specific** - Reference exact locations of changes
3. **Stay professional** - Never be defensive or dismissive
4. **Match the structure** - Respond to every point in order

---

## Scenario Templates

### 1. Accepting a Suggestion (Full Acceptance)

**When to use:** You agree with the reviewer and have implemented the change.

**Template:**
```
We thank the reviewer for this valuable suggestion. We have revised 
the [section/figure/analysis] to [describe change]. Specifically, 
we have [specific details of the change] (Page X, Lines Y-Z).
```

**Example:**
```
We thank the reviewer for this valuable suggestion. We have revised 
the methodology section to include detailed descriptions of our data 
preprocessing steps. Specifically, we have added a paragraph explaining 
normalization procedures, outlier detection criteria, and feature 
selection methods (Page 5, Lines 120-135).
```

---

### 2. Partial Acceptance (Modified Implementation)

**When to use:** You accept the spirit of the suggestion but implemented it differently.

**Template:**
```
We appreciate the reviewer's suggestion regarding [topic]. After 
careful consideration, we have adopted a modified approach. While 
[reviewer's suggestion], we found that [your approach] is more 
appropriate for our study because [brief rationale]. We have 
[describe what you did instead] (Page X, Lines Y-Z).
```

**Example:**
```
We appreciate the reviewer's suggestion regarding the statistical 
analysis. After careful consideration, we have adopted a modified 
approach. While the Wilcoxon test is commonly used, we found that 
the Mann-Whitney U test is more appropriate for our study because 
our groups are independent rather than paired. We have updated 
the statistical methods section accordingly (Page 8, Lines 200-210).
```

---

### 3. Politely Declining (With Rationale)

**When to use:** You disagree with the suggestion but want to maintain a professional tone.

**Template:**
```
We thank the reviewer for this suggestion. Upon careful consideration, 
we have maintained our original approach. [Brief, objective rationale]. 
However, we have [compromise/alternative if applicable] to address 
the reviewer's concern about [specific aspect].
```

**Example:**
```
We thank the reviewer for suggesting the removal of Figure 3. Upon 
careful consideration, we have maintained our original approach. 
This figure provides essential visual support for the temporal 
dynamics discussed in Section 4.2, which cannot be adequately 
conveyed in text alone. However, we have revised the figure caption 
to better emphasize its unique contribution and improved the color 
contrast for better clarity (Page 10, Figure 3).
```

---

### 4. Request for Additional Analysis

**When to use:** The reviewer requests new experiments or analyses.

**Accepted:**
```
We thank the reviewer for this excellent suggestion. We have 
conducted the additional analysis as requested. The results 
[show/support/indicate] [key finding], which we have added to 
[section] (Page X, Lines Y-Z, and new Figure/Table Z).
```

**Not feasible:**
```
We appreciate the reviewer's suggestion for additional analysis. 
We agree that such analysis would provide valuable insights. 
However, due to [specific constraint: data availability / time 
constraints / sample limitations], we are unable to conduct this 
analysis at this time. We have added a discussion of this limitation 
and its implications in the [section] (Page X, Lines Y-Z).
```

---

### 5. Literature Citation Request

**When to use:** The reviewer suggests citing specific papers.

**Template:**
```
We thank the reviewer for bringing these important references to 
our attention. We have now cited [Author et al., Year] and 
[Author et al., Year] in the [section/context] (Page X, Lines Y-Z). 
These papers indeed support our [argument/finding/approach] by [brief 
explanation of relevance].
```

---

### 6. Clarification Requests

**When to use:** The reviewer asks for clarification on methodology, results, or interpretation.

**Template:**
```
We apologize for the lack of clarity regarding [topic]. We have 
revised the text to provide a clearer explanation. Specifically, 
[detailed clarification] (Page X, Lines Y-Z). We hope this revision 
adequately addresses the reviewer's concern.
```

---

### 7. Major Concerns (Methodology, Validity)

**When to use:** Addressing fundamental concerns about the study design or conclusions.

**If making changes:**
```
We are grateful to the reviewer for raising this important concern. 
We acknowledge that our original [method/analysis/conclusion] was 
[problematic/limitation]. We have [describe major changes made]. 
These revisions have [impact on results/conclusions], which we have 
fully updated throughout the manuscript (Pages X-Y).
```

**If defending:**
```
We thank the reviewer for this important concern regarding [topic]. 
We have carefully reconsidered our approach and would like to provide 
the following clarification: [detailed explanation]. We believe our 
[method/approach/conclusion] is appropriate because [rationale with 
supporting evidence]. To address this concern, we have added a more 
detailed explanation in [section] (Page X, Lines Y-Z).
```

---

## Tone Adjustments

### From Defensive to Diplomatic

| Defensive ❌ | Diplomatic ✅ |
|-------------|---------------|
| We already explained this... | We apologize for the lack of clarity. We have now... |
| This is not correct... | We respectfully note that... |
| We don't think this is necessary... | Upon careful consideration, we have maintained... |
| The reviewer misunderstood... | We apologize if our explanation was unclear. We have revised... |

### Emphasis Modifiers

Use these to adjust the strength of your response:

**Strong agreement:**
- "We completely agree..."
- "This is an excellent point..."
- "We are grateful for this insight..."

**Moderate agreement:**
- "We thank the reviewer for this suggestion..."
- "We appreciate this observation..."
- "This is a valuable comment..."

**Respectful disagreement:**
- "We respectfully maintain..."
- "Upon careful consideration..."
- "We believe our approach remains appropriate..."

---

## Special Cases

### Multiple Reviewers with Conflicting Suggestions

```
We thank both Reviewers for their suggestions regarding [topic]. 
Reviewer #1 suggested [approach A], while Reviewer #2 suggested 
[approach B]. After careful consideration of both perspectives, 
we have [chosen approach/decision]. We believe this approach best 
addresses the concerns raised while [additional rationale].
```

### Revisions Beyond Scope

```
We thank the reviewer for this ambitious suggestion. While we agree 
that [extended analysis] would be valuable, this extends beyond the 
scope of the current study, which focuses on [current scope]. We have 
added a note about this potential extension as future work in the 
Discussion section (Page X, Lines Y-Z).
```
