# -*- coding: utf-8 -*-
"""
生成包含目录的完整翻译PDF
使用报告中的完整翻译内容
"""

# 完整翻译内容（从已有文件中读取）
FULL_TRANSLATION = r"""# 2026年智能编码发展趋势报告

## 编码代理如何重塑软件开发

---

## 前言：从辅助到协作

这些预测反映了我们今天在客户身上看到的情况，而非对明天的确定性预判。我们将其作为思考未来一年的框架，深知未来会给我们带来惊喜。

在2025年，编码代理从实验工具演进为能够向客户交付实际功能的生产系统。工程团队发现，AI如今可以独立完成整个实现工作流程：编写测试、修复故障、生成文档，并在日益复杂的代码库中自如穿梭。

我们预测，2026年这些进展将远超对现有工具或模型的增量改进。单一代理将演变为协同工作的代理团队。过去需要数小时甚至数天才能完成的任务，如今只需极少的人工干预。几年前还需要逐行编写代码的工程师，现在越来越多地管理着长期运行的代理系统，让它们处理实现细节，自己则专注于架构设计和战略规划。

然而，研究开发人员与AI的实际协作方式，我们发现了一个重要特点：这场转变本质上是协作性的。我们的社会影响研究团队数据显示，虽然开发人员在约60%的工作中使用AI，但他们真正能够完全委托的任务仅占0-20%。AI是持续的协作者，但要有效使用它，需要精心设置和提示、主动监督、结果验证，以及人类判断——尤其是在高风险工作中。

基于与客户的合作经验，本报告提出了我们预测将在2026年定义智能编码的八个趋势。这些预测分为三类：基础趋势（将重塑开发工作方式）、能力趋势（扩展代理能力边界）、影响趋势（将影响业务成果和组织结构）。

值得注意的是，这些趋势反映出早期采用者和后来者之间的差距正在扩大。那些能够在不制造瓶颈的前提下扩展人工监督的组织，更有可能在加快速度的同时保持质量。如今已掌握代理跨开发生命周期协调的团队，能够在数小时内而非数天内交付功能。将智能编码从工程团队扩展到非技术岗位的公司，有望在整个组织中释放生产力。

2026年呈现的趋势表明，软件开发正在向新模式演进：人类专注于定义值得解决的问题，AI负责实现层面的具体工作。

让我们深入了解。

---

## 基础趋势：构造性变革

---

## 趋势1：软件开发生命周期发生剧变

### 预测

**抽象层的变化**：编写、调试和维护代码的战术性工作大部分将转移给AI，工程师则专注于更高层次的工作，如架构设计、系统设计，以及决定构建什么产品的战略决策。

**工程角色的转变**：构建软件曾经主要意味着编写代码——尽管软件工程角色向来涉及多种技能。如今，软件工程师的工作越来越多地体现为：管理编写代码的代理、评估它们的输出、提供战略方向，并确保整个系统正确地解决了正确的问题。

**入职加速与动态人员配置**：熟悉新代码库或项目的传统周期将从数周缩短到数小时，这将改变公司对人才调配和项目资源的思考方式。

传统的SDLC阶段仍然存在，但代理驱动的实现、自动化测试和内联文档将周期时间从数周压缩到数小时。监控直接反馈到快速迭代中。

### 协作的现实

我们与计算机交互的方式正在经历自图形用户界面以来最重大的变化之一。从机器代码到汇编语言，再到C语言，再到现代高级语言，每个抽象层都缩小了人类思维和机器执行之间的差距。

这一演进的最近一步是人机对话。在2025年，智能AI改变了大量开发人员编写代码的方式。2026年注定是这一演进的系统性效应重新配置软件开发生命周期并重塑软件工程角色的一年。

虽然代理处理更多的实现工作，但这种转变揭示了一个重要事实：工程师在能力上变得更加全栈，而不是被取代。我们的研究表明，工程师现在可以有效地在前端、后端、数据库和基础设施工作——这些是他们以前可能缺乏专业知识的领域——因为AI填补了知识空白，而人类提供监督和方向。

这种能力扩展实现了更紧密的反馈循环和更快的学习。曾经需要几周跨团队协调的任务可以成为专注的工作会议。工程师描述使用AI来完成那些易于验证、定义明确或重复性的任务，同时自己保留高级设计决策以及需要组织背景或品味的任何事情。

### 角色转变：从实现者到编排者

到2026年，工程师贡献的价值转移到系统架构设计、代理协调、质量评估和战略问题分解。构建软件中人类的主要角色是编排编写代码的AI代理、评估它们的输出、提供战略方向，并确保系统为正确的利益相关者正确地解决正确的问题。

掌握编排的工程师可以同时指导多个功能通过开发，在比以前单个实现允许的更广泛范围内应用他们的判断。

### 入职革命

在2025年，新代码库或项目的传统入职时间表开始从几周崩溃到几小时。到2026年，我们预计组织将学习如何充分利用这一能力，改变公司对人才部署和资源分配的看法。

我们设想的一个表现形式是动态激增人员配置。企业将能够按需将工程师激增到需要深入代码库知识的任务上。组织可以开始动态地为项目配备人员，为特定挑战带来专家，并在没有传统生产力下降的情况下转移资源。

Augment Code是一家为网络平台、数据库和存储基础设施等系统构建AI驱动的软件开发工具的初创公司，它通过使用Claude提供上下文代码理解，平滑了工程师加入新代码库或项目的学习曲线。一位企业客户使用由Claude驱动的Augment Code，在仅两周内完成了一个他们的CTO最初估计需要4到8个月的项目。

---

## 能力趋势：代理能够做什么

---

## 趋势2：单一代理演变为协作团队

我们预测，到2026年，组织将能够利用多个代理协同工作来处理仅在一年前难以想象的任务复杂性。这种能力将需要任务分解、代理专业化和协调协议方面的新技能，以及显示多个并发代理会话状态的开发环境和处理同时生成的代理贡献的版本控制工作流。

单一代理工作流通过一个上下文窗口顺序处理任务。多代理架构使用编排器来协调并行工作的专业代理——每个代理都有专门的上下文——然后将结果综合成集成输出。

### 预测

**多代理系统取代单一代理工作流**：组织采用多代理工作流，通过跨独立上下文窗口的并行推理最大化性能提升。

Fountain是一个一线劳动力管理平台，使用Claude进行分层多代理编排，实现了50%更快的筛选、40%更快的入职和2倍候选人转化率。

他们的Fountain Copilot充当中央编排代理，协调用于候选人筛选、自动文档生成和情感分析的专业子代理。这种架构使一个物流客户将完全配备新履行中心所需的时间从一周或多周缩短到不到72小时。

---

## 趋势3：长时间运行的代理构建完整系统

早期的代理处理最多需要几分钟的一次性任务：修复这个bug，编写这个函数，生成这个测试。到2025年底，越来越熟练的AI代理在几个小时内生成完整的功能集。到2026年，代理将能够一次工作几天，在关键决策点进行最少的人工干预来提供战略监督，构建整个应用程序和系统。

在Rakuten，工程师测试了Claude Code在一个复杂技术任务上的能力：在vLLM中实现特定的激活向量提取方法，这是一个包含1250万行代码的大型开源库，使用多种编程语言。Claude Code在一次运行中通过七小时的自主工作完成了整个工作。与参考方法相比，该实现实现了99.9%的数值精度。

### 预测

**任务范围从分钟扩展到天或周**：代理从处理在几分钟内完成的离散任务演变为在很长一段时间内自主工作，定期人工检查点，构建和测试整个应用程序和系统。

**代理处理软件开发的混乱现实**：长时间运行的代理在数十个工作会话中计划、迭代和改进，适应发现，从失败中恢复，并在整个复杂项目中保持连贯状态。

**软件开发经济发生变化**：当代理可以长时间自主工作时，以前不可行的项目变得可行。多年来因为没有人时间处理而积累的技术债务被代理通过待办事项列表系统地消除。

**上市路径加速**：创业者使用代理在几天而不是几个月内从想法到部署的应用程序。

---

## 趋势4：通过智能协作扩展人工监督

也许2026年最有价值的能力发展是代理学习何时寻求帮助，而不是盲目地尝试每个任务，以及人类仅在需要时介入循环。这不是关于从过程中移除人类——而是关于使人类注意力在最关键的地方发挥作用。

工程师描述了随着时间推移对AI委托发展直觉。随着模型的改进，这种情况正在迅速变化，但历史上，他们倾向于委托那些易于验证的任务——他们可以相对容易地嗅探检查正确性的任务——或者低风险的任务，比如快速脚本来追踪bug。概念上越困难或依赖设计的任务，工程师越可能自己保留或与AI合作完成，而不是完全移交。

### 协作悖论

Anthropic的内部研究显示了一个重要模式：虽然工程师报告在大约60%的工作中使用AI并实现显著的生产力提升，但他们也报告只能完全委托一小部分任务。当你理解有效的AI协作需要积极的人类参与时，明显的矛盾就解决了。

即使在AI能力扩展的同时，人类角色仍然保持中心。转变从编写代码到审查、指导和验证AI生成的代码。正如我们的一位工程师所说：我在我知道答案应该是什么或应该看起来是什么的情况下主要使用AI。我通过困难的方式进行软件工程发展了这种能力。

### 预测

**代理质量控制成为标准**：组织使用AI代理审查大规模AI生成的输出，分析代码的安全漏洞、架构一致性和质量问题，这些问题会压倒人类能力。

**代理学习何时寻求帮助**：复杂的代理识别需要人类判断的情况，标记不确定性领域并提升具有潜在业务影响的决策。

**人工监督从审查一切转变为审查重要的事情**：团队通过构建智能系统来同时保持质量和速度，该系统处理常规验证，同时将真正新颖的情况、边界情况和战略决策升级为人工输入。

在CRED，一个在印度服务超过1500万用户的金融科技平台，工程师在整个开发生命周期中实施了Claude Code，以在保持金融服务必需的质量标准的同时加速交付。由Claude驱动的开发系统将他们的执行速度提高了一倍——不是通过消除人类参与，而是通过将开发者转向更高价值的工作。

---

## 趋势5：智能编码扩展到新领域和用户

最早的智能编码浪潮专注于帮助专业软件工程师在熟悉的环境中更快工作。到2026年，智能编码准备扩展到传统开发工具无法到达的上下文和用例，从传统语言到新的形式因素，使访问民主化，超越传统开发人员。

在Legora，一个AI驱动的法律平台，代理工作流集成到他们的法律技术平台中，展示了编码代理如何扩展到领域特定应用。

我们发现Claude在指令遵循和构建代理及代理工作流程方面非常出色，Legora首席执行官Max Junestrand说。该公司使用Claude Code来加速他们自己的开发，同时为需要创建复杂自动化而没有工程专业知识律师提供代理能力。

### 预测

**语言障碍消失**：支持扩展到不太常见和传统语言，如COBOL、Fortran和领域特定语言，实现传统系统的维护并消除专业用例的采用障碍。

**编码在工程之外民主化**：新的形式因素和界面为网络安全、运营、设计和数据科学等领域的非传统开发人员打开了智能编码。像Cowork这样为非开发人员设计以自动化文件和任务管理的工具表明这种转变已经进行。

### 每个人都变得更全栈

分析不同团队如何使用AI揭示了一个一致的模式：人们使用AI来增强他们的核心专业知识，同时扩展到相邻领域。安全团队使用它来分析不熟悉的代码。研究团队使用它来构建数据的前端可视化。非技术员工使用它来调试网络问题或执行数据分析。

这种扩展挑战了长期以来的假设，即严肃的开发工作只能在IDE中进行，或者只有拥有专业工具的专业工程师才能使用代码来解决问题。分隔编码的人和不编码的人的障碍变得更加可渗透。

---

## 影响趋势：202年代理可能带来的变化

---

## 趋势6：生产力提升重塑软件开发经济

明智地将代理集成到其软件开发生命周期中的组织将看到时间线压缩，影响项目的可行性以及公司如何快速响应市场机会。

值得注意的是，大约27%的AI辅助工作由本来不会完成的任务组成：扩展项目、构建不错的工具，如如果手动完成则不具有成本效益的交互式仪表板和探索性工作。工程师报告修复更多的纸割伤——改善生活质量但通常被推迟的小问题——因为AI使解决它们成为可行。

### 通过产出量而非仅仅是速度提高生产力

Anthropic的内部研究显示了一个有趣的生产力模式：工程师报告每个任务类别花费的时间净减少，但产出量的净增加大得多。这表明AI主要通过更高的产出实现更高的生产力——更多的功能交付、更多的bug修复、更多的实验运行——而不仅仅是更快地完成相同的工作。

### 预测

**三个倍增驱动加速**：代理能力、编排改进和更好地利用人类经验复合产生阶梯函数改进而非线性增益，因为每个都使其他成为可能。

**时间线压缩改变项目可行性**：曾经需要几周的开发现在需要几天，使以前不可行的项目可行，并使组织能够更快地响应市场机会。

**软件开发经济转变**：总拥有成本下降，因为代理增强工程师能力、项目时间表缩短，更快的价值实现提高投资回报率。

在TELUS，一家领先的通信技术公司，团队创建了超过13,000个定制AI解决方案，同时工程代码交付速度提高30%。该公司已节省超过500,000小时，平均每次AI互动节省40分钟。

---

## 趋势7：非技术用例扩展到整个组织

我们预计2026年最重要的趋势之一将是功能和业务流程团队使用智能编码稳步增长，为他们遇到的问题创建自己的解决方案，并改进他们每天使用的流程。

### Anthropic如何使用Claude Code

我们的法律团队通过构建由Claude驱动的工作流程，将营销审查周转时间从两到三天缩短到24小时，自动化重复性任务，如合同修订和内容审查。使用Claude Code，一位没有编码经验的律师构建了自助服务工具，在问题进入法律队列之前进行分流，使律师能够专注于战略咨询而不是战术繁重工作。

结果：律师减少了成为瓶颈的可能性，可以将时间用于其他更紧迫的事情。

### 预测

**编码能力在工程之外民主化**：跨销售、营销、法律和运营的非技术团队获得自动化工作流程和构建工具的能力，需要很少或没有工程干预或编码专业知识。

**领域专家直接实施解决方案**：深刻理解问题的动手专家获得使用代理自己启动解决方案的信心，消除提交工单然后等待开发团队的瓶颈。

**生产力提升扩展到整个组织**：不值得工程时间的问题得到解决，实验性工作流程变得微不足道，手动流程得到自动化。

Zapier是一个领先的AI编排平台，已经使其所有员工都能访问代理。设计团队在客户访谈期间使用Claude工件快速原型设计，实时显示设计概念，通常需要几周才能开发。该公司在整个组织实现了89%的AI采用率，内部部署了800多个AI代理。

---

## 趋势8：智能编码改善安全防御——但也有攻击性用途

智能编码同时在两个方向上改变安全。随着模型变得更强大和更好对齐，将安全性构建到产品中变得更容易。现在，任何工程师都可以利用AI执行以前需要专业知识的安全审查、强化和监控。但同样有助于防御者的能力也有能力帮助攻击者扩展他们的工作。

### 预测

**安全知识民主化**：随着改进的代理，任何工程师都可以成为能够进行深入安全审查、强化和监控的安全工程师。工程师仍然需要考虑安全并与专家协商，但构建强化和安全应用程序将变得更容易。

**威胁行为者扩展攻击**：虽然代理将有利于防御用途，但它们也将有利于攻击用途。为了防御这种双重用途技术，工程师从一开始就构建安全性将变得更加重要。

**代理网络防御系统兴起**：自动化代理系统实现机器速度的安全响应，自动化检测和响应以匹配自主威胁的步伐。

平衡有利于准备好的组织。从一开始就使用代理工具烘焙安全的团队将更好地定位以防御使用相同技术的对手。

---

## 未来一年的优先事项

这八个趋势注定在2026年定义智能编码的所有内容都集中在一个中心主题上：软件开发正在从以编写代码为中心的活动转变为基于编排编写代码的代理的活动——同时维护确保质量结果的人类判断、监督和协作。

研究很清楚：AI是一个持续的协作者，但有效使用它需要主动的监督和验证，尤其是在高风险工作中。虽然更多的常规编码任务可以委托给AI，但人类仍在审查代码。这不是完全委托而是高度协作。这种区别对于组织如何处理AI采用以及他们如何思考工程师的演变角色很重要。

对于计划2026年优先事项的组织，四个领域需要立即关注：

1. 掌握多代理协调，处理单一代理系统无法解决的复杂性
2. 通过AI自动化审查系统扩展人工代理监督，将人类注意力集中在最重要的地方
3. 将智能编码扩展到工程之外，赋予各部门领域专家权力
4. 从最早阶段开始将安全架构作为代理系统设计的一部分

在2026年将智能编码作为战略优先事项的组织将定义可能成为什么，而那些将其视为增量生产力工具的组织将发现他们在一场新规则的游戏中竞争。成功的关键在于理解目标不是从循环中移除人类——而是使人类专业知识在最关键的地方发挥作用。

---

Claude.ai
"""

# PDF生成代码
from reportlab.lib.pagesizes import A4
from reportlab.lib.styles import getSampleStyleSheet, ParagraphStyle
from reportlab.lib.units import inch
from reportlab.platypus import SimpleDocTemplate, Paragraph, Spacer, PageBreak
from reportlab.lib.enums import TA_CENTER, TA_JUSTIFY
from reportlab.pdfbase import pdfmetrics
from reportlab.pdfbase.ttfonts import TTFont
from reportlab.lib.colors import HexColor
import os
import re

def register_fonts():
    """注册中英文字体"""
    # 中文字体路径（优先级：STHeiti > PingFang > others）
    chinese_font_paths = [
        '/System/Library/Fonts/STHeiti Light.ttc',  # macOS 黑体（推荐）
        '/System/Library/Fonts/PingFang.ttc',       # macOS 苹方
        '/System/Library/Fonts/Helvetica.ttc',      # 后备
        'C:/Windows/Fonts/msyh.ttc',                # Windows 微软雅黑
        'C:/Windows/Fonts/simhei.ttf',              # Windows 黑体
        '/usr/share/fonts/truetype/droid/DroidSansFallbackFull.ttf',  # Linux
    ]

    # 注册中文字体
    chinese_font = None
    for font_path in chinese_font_paths:
        if os.path.exists(font_path):
            try:
                pdfmetrics.registerFont(TTFont('ChineseFont', font_path, subfontIndex=0))
                chinese_font = 'ChineseFont'
                break
            except Exception as e:
                continue

    if not chinese_font:
        chinese_font = 'Helvetica'

    # 注册英文字体（用于英文关键词和专有名词）
    try:
        pdfmetrics.registerFont(TTFont('EnglishFont', '/System/Library/Fonts/Helvetica.ttc', subfontIndex=0))
        english_font = 'EnglishFont'
    except:
        english_font = 'Helvetica'

    return chinese_font, english_font


def apply_mixed_font(text, english_font):
    """应用中英文字体混排"""
    # 匹配英文文本的模式（包括常见缩写）
    english_pattern = r'([a-zA-Z0-9_\-\.]+(?:\s+[a-zA-Z0-9_\-\.]+)*)'

    def replace_english(match):
        english_text = match.group(1)
        # 检查是否是常见缩写或技术术语
        common_terms = ['API', 'JSON', 'PDF', 'AI', 'URL', 'HTTP', 'REST', 'SQL', 'HTML', 'CSS', 'Claude', 'GitHub', 'SDK']
        if any(term in english_text for term in common_terms):
            return f'<font name="{english_font}">{english_text}</font>'
        # 检查是否是较长的英文短语（可能是专有名词）
        if len(english_text.split()) > 2 or len(english_text) > 10:
            return f'<font name="{english_font}">{english_text}</font>'
        return english_text

    # 应用字体到英文文本
    result = re.sub(english_pattern, replace_english, text)
    return result


def markdown_to_pdf_content(markdown_text, chinese_font, english_font):
    """将Markdown文本转换为PDF内容"""
    lines = markdown_text.split('\n')
    content = []
    current_heading = None

    for line in lines:
        line = line.rstrip()
        if not line:
            continue

        # 处理标题
        if line.startswith('## '):
            current_heading = line[3:].strip()
            content.append(('heading1', current_heading))
            content.append(('spacer', 12))
        elif line.startswith('### '):
            content.append(('heading2', line[4:].strip()))
            content.append(('spacer', 10))
        elif line.startswith('**') and line.endswith('**'):
            # 粗体文本
            content.append(('bold', line[2:-2].strip()))
        elif line.startswith('---'):
            # 分隔线
            content.append(('pagebreak', ''))
        else:
            # 普通段落
            if line.strip():
                content.append(('paragraph', line.strip()))

    return content


def create_pdf_with_toc():
    """创建包含目录的完整翻译PDF"""

    output_path = "/Users/chrislee/Documents/Projects/知识博主/资料分享/2026_Agentic_Coding_Trends_Report_中文版_完整版.pdf"

    doc = SimpleDocTemplate(output_path, pagesize=A4,
                            leftMargin=0.75*inch, rightMargin=0.75*inch,
                            topMargin=0.75*inch, bottomMargin=0.75*inch)

    styles = getSampleStyleSheet()

    # 自定义样式
    title_style = ParagraphStyle(
        'CustomTitle',
        parent=styles['Heading1'],
        fontName='ChineseFont',
        fontSize=24,
        textColor=HexColor('#1a1a1a'),
        spaceAfter=30,
        alignment=TA_CENTER,
        leading=32
    )

    subtitle_style = ParagraphStyle(
        'CustomSubtitle',
        parent=styles['Normal'],
        fontName='ChineseFont',
        fontSize=14,
        textColor=HexColor('#666666'),
        spaceAfter=10,
        alignment=TA_CENTER,
        leading=20
    )

    heading1_style = ParagraphStyle(
        'CustomHeading1',
        parent=styles['Heading1'],
        fontName='ChineseFont',
        fontSize=18,
        textColor=HexColor('#2563eb'),
        spaceAfter=12,
        spaceBefore=20,
        leading=24
    )

    heading2_style = ParagraphStyle(
        'CustomHeading2',
        parent=styles['Heading2'],
        fontName='ChineseFont',
        fontSize=16,
        textColor=HexColor('#1e40af'),
        spaceAfter=10,
        spaceBefore=15,
        leading=22
    )

    body_style = ParagraphStyle(
        'CustomBody',
        parent=styles['BodyText'],
        fontName='ChineseFont',
        fontSize=11,
        textColor=HexColor('#374151'),
        spaceAfter=8,
        leading=16,
        alignment=TA_JUSTIFY
    )

    # 注册字体
    chinese_font, english_font = register_fonts()
    print(f"✅ 使用中文字体: {chinese_font}")
    print(f"✅ 使用英文字体: {english_font}")

    story = []

    # 封面页
    story.append(Paragraph("2026年智能编码发展趋势报告", title_style))
    story.append(Spacer(1, 12))
    story.append(Paragraph("编码代理如何重塑软件开发", subtitle_style))
    story.append(PageBreak())

    # 目录页（重点！）
    story.append(Paragraph("目录", heading1_style))
    story.append(Spacer(1, 20))

    # 目录内容（使用显式结构）
    toc_items = [
        ("", "前言：从辅助到协作", "3"),
        ("基础趋势", "构造性变革", "4"),
        ("", "趋势1：软件开发生命周期发生剧变", "4"),
        ("能力趋势", "代理能够做什么", "7"),
        ("", "趋势2：单一代理演变为协作团队", "7"),
        ("", "趋势3：长时间运行的代理构建完整系统", "8"),
        ("", "趋势4：通过智能协作扩展人工监督", "9"),
        ("", "趋势5：智能编码扩展到新领域和用户", "10"),
        ("影响趋势", "202年代理可能带来的变化", "11"),
        ("", "趋势6：生产力提升重塑软件开发经济", "11"),
        ("", "趋势7：非技术用例扩展到整个组织", "12"),
        ("", "趋势8：智能编码改善安全防御——但也有攻击性用途", "13"),
        ("", "未来一年的优先事项", "14"),
    ]

    for category, title, page in toc_items:
        if category:  # 有分类的目录项
            story.append(Paragraph(f"<b>{category}</b>：{title} ………………………… {page}", body_style))
        else:  # 无分类的目录项
            story.append(Paragraph(f"{title} ………………………… {page}", body_style))
        story.append(Spacer(1, 6))

    story.append(PageBreak())

    # 解析Markdown内容并添加到story
    content = markdown_to_pdf_content(FULL_TRANSLATION, chinese_font, english_font)

    for item_type, item_content in content:
        if item_type == 'heading1':
            story.append(Paragraph(apply_mixed_font(item_content, english_font), heading1_style))
        elif item_type == 'heading2':
            story.append(Paragraph(apply_mixed_font(item_content, english_font), heading2_style))
        elif item_type == 'paragraph':
            # 处理粗体（只处理单个**对）
            processed_content = item_content
            # 简单处理：将 **text** 替换为 <b>text</b>
            import re
            processed_content = re.sub(r'\*\*([^*]+)\*\*', r'<b>\1</b>', processed_content)
            story.append(Paragraph(apply_mixed_font(processed_content, english_font), body_style))
        elif item_type == 'bold':
            story.append(Paragraph(f"<b>{apply_mixed_font(item_content, english_font)}</b>", body_style))
        elif item_type == 'spacer':
            story.append(Spacer(1, item_content))
        elif item_type == 'pagebreak':
            story.append(PageBreak())

    # 生成PDF
    doc.build(story)
    print(f"✅ PDF生成成功：{output_path}")
    print("- 包含完整目录（第2页）")
    print("- 包含全部8个趋势")
    print("- 使用黑体中文字体")
    print("- 使用Helvetica英文字体")
    print("- 应用中英文字体混排")


if __name__ == '__main__':
    create_pdf_with_toc()
