# PDF Tools Skill

A comprehensive OpenClaw skill for viewing, extracting, editing, and manipulating PDF files using Python libraries (pdfplumber, PyPDF2, and reportlab).

## Features

- 📄 **Text Extraction** - Extract text from entire PDFs or specific pages
- ✏️ **Text Editing** - Add text overlays to PDF pages with custom positioning and font size
- 📊 **PDF Info** - View metadata, page count, dimensions, and document properties
- 🔗 **Merge PDFs** - Combine multiple PDF files into one
- ✂️ **Split PDFs** - Split by individual pages or custom page ranges
- 🔄 **Rotate Pages** - Rotate pages at 90°, 180°, 270°, or -90° angles

## Installation

### Dependencies

Install required Python packages:

```bash
pip3 install pdfplumber PyPDF2 reportlab
```

### Skill Installation

1. Download `pdf-tools-clawhub.zip`
2. Extract to your OpenClaw skills directory:
   ```bash
   unzip pdf-tools-clawhub.zip -d ~/.openclaw/workspace/skills/
   mv ~/.openclaw/workspace/skills/pdf-tools-for-clawhub ~/.openclaw/workspace/skills/pdf-tools
   ```
3. The skill will be automatically loaded by OpenClaw

## Usage

Simply ask your OpenClaw agent:

- "Extract text from this PDF"
- "Add 'CONFIDENTIAL' text to page 1"
- "Rotate pages 1-3 by 90 degrees"
- "Merge these 3 PDF files"
- "Split this PDF into separate pages"
- "Show me info about this PDF"

The agent will automatically use the appropriate script!

## Scripts Reference

### Extract Text

```bash
scripts/extract_text.py document.pdf
scripts/extract_text.py document.pdf -p 1 3 5
scripts/extract_text.py document.pdf -o output.txt
```

### Edit Text

Add text overlay:
```bash
scripts/edit_text.py input.pdf -o output.pdf --overlay "New Text" --page 1 --x 100 --y 700
scripts/edit_text.py input.pdf -o output.pdf --overlay "Watermark" --page 1 --x 200 --y 400 --font-size 20
```

Replace text (limited due to PDF format complexity):
```bash
scripts/edit_text.py input.pdf -o output.pdf --replace "Old Text" "New Text"
```

**Note:** Text overlay is more reliable than replacement due to PDF format complexity.

### Get PDF Info

```bash
scripts/pdf_info.py document.pdf
scripts/pdf_info.py document.pdf -f json
```

### Merge PDFs

```bash
scripts/merge_pdfs.py file1.pdf file2.pdf file3.pdf -o merged.pdf
```

### Split PDF

Split into individual pages:
```bash
scripts/split_pdf.py document.pdf -o output_dir/
```

Split by page ranges:
```bash
scripts/split_pdf.py document.pdf -o output_dir/ -m ranges -r "1-3,5-7,10-12"
```

### Rotate Pages

```bash
scripts/rotate_pdf.py document.pdf -o rotated.pdf -r 90
scripts/rotate_pdf.py document.pdf -o rotated.pdf -r 180 -p 1 3 5
```

## Advanced Usage

For detailed library documentation and advanced patterns, see [references/libraries.md](references/libraries.md).

## Examples

### Extract and translate a PDF

```bash
# Extract text
scripts/extract_text.py original.pdf -o extracted.txt

# Translate the text (using your preferred method)
# ...

# Create new PDF with translated text (requires custom script or reportlab)
```

### Add watermark to all pages

```bash
# For each page, add overlay with watermark text
scripts/edit_text.py input.pdf -o watermarked.pdf --overlay "DRAFT" --page 1 --x 300 --y 400 --font-size 48
```

## Technical Notes

- **Page numbers** are 1-indexed in all scripts (page 1 = first page)
- **Text extraction** works best with text-based PDFs (not scanned images)
- **Rotation angles** must be 90, 180, 270, or -90 (counterclockwise)
- **Text editing** uses overlay method (more reliable) or simple replacement (limited)
- **Cyrillic support** requires fonts like DejaVuSans or Liberation (auto-detected)

## Limitations

- PDF text replacement is limited due to format complexity (encoding, positioning, fonts)
- For complex text editing, consider: extract → edit → regenerate PDF
- Scanned PDFs require OCR for text extraction (not included)

## Contributing

Found a bug or have a feature request? Please report it on the OpenClaw community forums or GitHub.

## License

MIT License - feel free to modify and distribute.

## Author

Created by @cmpdchtr
