---
name: paywall-upgrade-designer
description: Redesign paywall and upgrade screens to maximize free-to-paid conversion. Use when a user wants to improve their SaaS upgrade screen, paywall copy, plan structure, pricing psychology, CTA copy, or overall upgrade flow. Produces a full conversion-optimized upgrade screen spec using the Upgrade Moment Method framework.
---

# Paywall Upgrade Designer

**Version:** 1.0.0  
**Author:** Remy Claw  
**Price:** $29  
**Category:** Marketing / Conversion Optimization

---

## What This Skill Does

This skill turns your AI assistant into a conversion-focused paywall strategist. You describe (or paste) your current upgrade screen, and the skill guides the AI to produce a complete redesign: headline rewrites, plan naming, CTA copy, risk reversal, social proof placement, and full ready-to-implement upgrade screen copy.

The underlying framework — **The Upgrade Moment Method** — treats the paywall not as a gate, but as a sales conversation that happens to live inside your product.

---

## Instructions for the AI

When this skill is activated, follow every section in order. Do not skip steps. The output quality depends on completeness.

---

### STEP 1 — Gather Context

Ask the user for the following. Collect everything before proceeding.

**Required inputs:**
1. **Current paywall/upgrade screen copy** — paste it in full (headline, subheadline, plan names, feature bullets, CTA, any fine print)
2. **Product name and category** — e.g. "Notion-style writing tool", "B2B analytics dashboard", "consumer fitness app"
3. **Target customer** — who is the free user? What job are they hiring the product to do?
4. **What triggers the upgrade screen?** — e.g. hitting a usage limit, trying a locked feature, manual profile page visit
5. **Current pricing** — plan names, price points, billing options (monthly/annual)
6. **Biggest customer objection to upgrading** — if known (e.g. "too expensive", "I don't use it enough", "I'm not sure I need it")
7. **Any existing social proof** — customer logos, testimonials, user counts, G2/Capterra ratings

If the user says they don't have some of this, ask them to estimate or describe what they know. Never proceed with an empty context.

---

### STEP 2 — Current Paywall Assessment

Analyze what the user has shared against the **Upgrade Moment Method** — the three simultaneous jobs every effective paywall must do:

1. **Make the value of upgrading crystal clear** (not a features list — outcomes and transformations)
2. **Reduce the perceived risk of paying** (trial, guarantee, no credit card)
3. **Create urgency that is earned, not manufactured** (real usage limits, real deadlines — never fake scarcity)

Produce a structured assessment with two sections:

**What's Working**
List any elements that are already doing one of the three jobs well. Be honest — if nothing is working, say so directly.

**What's Killing Conversion**
List the specific copy, structural, or strategic problems. Be specific. Don't say "the copy is generic" — say what the copy is doing wrong and why it fails. Common failure modes to look for:

- Feature lists instead of outcome copy ("Unlimited projects" vs "Finish everything you start")
- Generic plan names ("Basic / Pro / Enterprise") that communicate tier, not value
- CTAs that describe the action, not the result ("Upgrade Now" vs "Get Unlimited Access")
- No risk reversal — asking for money with no safety net
- Social proof absent or buried below the fold
- Hard paywall where a soft paywall would work better (and vice versa)
- Paywall triggering at the wrong moment (before value is demonstrated)
- Downgrade path that feels punishing, creating upgrade fear instead of upgrade trust

---

### STEP 3 — Trigger Placement Strategy

Evaluate WHERE the upgrade screen appears in the product journey. This is often the highest-leverage fix available.

**Explain the difference:**

- **Natural upgrade moment:** The user is mid-task, hits a real limit, and upgrading immediately unblocks them. Conversion is highest here because desire and the solution are simultaneous.
- **Arbitrary gate:** The upgrade screen appears before the user has experienced enough value to justify paying. This generates resentment, not conversions.
- **Cold surfaces:** Pricing page, settings → billing. Lower intent. Need more persuasion.

**Deliver:**
- Assessment of whether the current trigger placement is a natural moment or an arbitrary gate
- Recommended trigger placement(s) if current placement is suboptimal
- One-sentence rationale for each recommendation

**Soft vs Hard Paywall recommendation:**

| Use a soft paywall when... | Use a hard paywall when... |
|---|---|
| The feature can be previewed or partially used | The feature cannot exist in a limited form |
| You want to demonstrate value before the ask | The feature is the entire product |
| The user hasn't hit a natural desire peak yet | Usage limits have been genuinely reached |
| Churn risk is high if they feel forced | Trust is already established |

Give a clear recommendation: soft or hard paywall for this product, and why.

---

### STEP 4 — Value Framing Rewrite

**The Rule:** Never lead with features. Lead with the outcome the feature enables.

Feature → Outcome translation examples:
- "Unlimited projects" → "Finish everything you start, nothing left behind"
- "Advanced analytics" → "Know exactly what's working before your next meeting"
- "Team collaboration" → "Stop losing work to email threads and missed Slack messages"
- "Priority support" → "Get unstuck in hours, not days"
- "Custom integrations" → "Your tools, your workflow — no switching tabs to get things done"

**Produce:**
- The 3-5 most important outcomes the paid plan delivers for THIS user (based on the context gathered)
- For each: the feature it maps to + the outcome framing
- Flag any features in the current copy that have no clear outcome — suggest cutting or reframing

---

### STEP 5 — Plan Names & Structure

Generic tier names ("Free / Pro / Enterprise") communicate rank, not value. Outcome-based names convert better.

**Naming framework:**

Instead of naming by tier, name by:
- **Who the plan is for** (Solo / Team / Agency)
- **What the plan enables** (Starter / Growth / Scale)
- **The transformation** (Do More / Ship Faster / Win More)
- **The usage pattern** (Individual / Professional / Unlimited)

**Rules for plan structure:**
- 2-3 plans maximum on the upgrade screen. More creates decision paralysis.
- Mark one plan as "Most Popular" or "Best Value" — reduces cognitive load, anchors the decision
- Annual billing toggle should default to annual if the discount is ≥ 20%
- The free plan (if shown) should look noticeably limited by design, not just labeled "Free"

**Deliver:**
- 2-3 recommended plan name options (with brief rationale)
- Recommended plan to highlight as the default/"most popular"
- Annual/monthly toggle recommendation with suggested framing for the annual savings ("Save 40%" not "2 months free" — test both, but lead with percentage)

---

### STEP 6 — Pricing Psychology

Apply these principles to the user's specific pricing:

**Anchoring:** Always show the highest-value plan first (left to right, or top to bottom on mobile). This anchors perception before the buyer evaluates middle options.

**Charm pricing:** $29/mo outperforms $30/mo. $97/yr outperforms $99/yr. Adjust recommendations if the current prices end in round numbers.

**Annual framing:** Never say "pay $X less per year." Say "Get [Product] for $X/month" (showing the monthly equivalent of annual billing). The lower monthly number is the anchor.

**The decoy effect:** If there are 3 plans, the middle plan should feel like the obvious choice. Make the entry plan feel slightly limiting and the top plan feel slightly unnecessary.

**Deliver:**
- Assessment of current pricing psychology (is anchoring working? are prices charm-priced?)
- Specific recommendations to improve pricing perception without changing the actual prices
- How to structure the plans visually to drive toward the target plan

---

### STEP 7 — Risk Reversal

The single fastest conversion lift available. Every paid upgrade screen should have at least one risk reversal element.

**Risk reversal hierarchy (strongest to weakest):**
1. **No credit card required trial** — removes all financial commitment (best for low-ARPU SaaS)
2. **14-day free trial** (credit card required) — filters for intent, still strong
3. **30-day money-back guarantee** — strong for annual plans, annual commitment fear
4. **"Cancel anytime"** — table stakes for monthly billing, barely moves conversion alone
5. **Free plan available** — weakest form; only works if the free plan is genuinely useful

**Placement rules:**
- Risk reversal copy belongs directly below the CTA button — not in fine print, not in a footer
- Use specific language: "30-day money-back guarantee — no questions, no forms, one click"
- If there's a trial, state the exact number of days and what happens at the end

**Deliver:**
- Recommended risk reversal type for this product
- Exact copy for the risk reversal element (ready to place below CTA)
- Where to place it on the screen

---

### STEP 8 — Social Proof at Point of Upgrade

Social proof positioned at the decision moment converts better than social proof anywhere else on the page.

**What works at the upgrade screen:**

- **Micro-testimonials:** 1-2 sentences, specific outcome, real name + company/role. Not "Great product!" — "I closed 3 deals last month that I would have missed without the alerts."
- **Logo bar:** 5-7 recognizable company logos. B2B plays. Position above the fold near the headline.
- **User count / usage stats:** "Trusted by 12,000+ teams" — only use if the number is impressive
- **Star ratings:** G2/Capterra badges convert well for SMB SaaS. Place near CTA.
- **Before/after:** A single data point that shows transformation. "Teams using [Product] close 31% more deals in their first 60 days."

**What kills social proof:**
- Generic quotes with no specifics
- Stock photos on testimonials (real photos or avatars only)
- Testimonials that describe the product, not the outcome
- Social proof that doesn't match the buyer's profile (enterprise logos on a consumer product, or vice versa)

**Deliver:**
- Which social proof types are most appropriate for this product and buyer
- Where to place each on the upgrade screen
- If the user has existing social proof: assessment of quality + rewrite suggestions
- If no social proof exists: what to collect first and how to ask for it

---

### STEP 9 — CTA Copy

"Upgrade Now" is the most common CTA on SaaS upgrade screens. It also communicates nothing about what the user gets.

**CTA formula:**
> [Verb] + [Outcome or Access] = higher intent, higher conversion

**Examples:**
- "Start Writing Without Limits" (writing tool)
- "Get Full Access — 14 Days Free" (trial offer)
- "Unlock My Dashboard" (analytics tool)
- "Start My Free Trial" (generic but outcome-implicit)
- "Join 12,000+ Teams Who Ship Faster" (social proof embedded in CTA)
- "Get Everything — Cancel Anytime" (risk reversal embedded in CTA)

**Deliver:**
- 3 CTA copy options, each using a different strategy:
  1. Outcome-focused (benefit of upgrading)
  2. Access-focused (what they unlock)
  3. Risk-reversal-embedded (safety + action combined)
- Recommended secondary CTA (for users not ready to buy): "See all features" or "Compare plans" — never "Maybe later" (too dismissive)

---

### STEP 10 — Downgrade Path Design

How you handle cancellation determines whether churned users come back. A punishing downgrade path creates upgrade fear, suppressing initial conversions.

**The principle:** Make downgrading feel safe. Users who feel safe downgrading are more likely to upgrade in the first place.

**Best practices:**
- Never delete data on downgrade. Archive it, lock it — but never delete it.
- Show the user what they keep, not just what they lose
- Offer a pause option before cancellation ("Pause my account for 30 days")
- Offer a downgrade to a lower paid tier before surfacing the free/cancel option
- Exit survey — always. The data is worth more than the friction.
- Follow-up email 7 days after churn: not a win-back pitch, just a check-in. Lower pressure, higher reactivation rate.

**On the cancellation screen:**
- Show one win-back offer: extended trial, one-month discount, or feature unlock
- Don't make them feel bad for leaving — that feeling stays and prevents return

**Deliver:**
- Assessment of current downgrade path (if described)
- Recommended downgrade flow (step by step)
- Copy for the cancellation screen offer
- Recommended win-back email timing and framing (one sentence each)

---

### STEP 11 — Full Redesigned Upgrade Screen

Compile everything from Steps 3–10 into a complete, ready-to-implement upgrade screen. Structure it as a written spec that a designer or developer can act on directly.

**Format:**

---

**[UPGRADE SCREEN SPEC]**

**Trigger moment:** [When this screen appears]
**Paywall type:** Soft / Hard

**Above the fold:**

*Headline:* [Rewritten headline — outcome-focused]

*Subheadline:* [1-2 sentences — expands on the headline, addresses the core objection]

*Social proof bar:* [Logo bar / user count / star rating — positioned here]

**Plan section:**

| Plan Name | Price | Positioning |
|---|---|---|
| [Name 1] | $X/mo | [Who it's for] |
| [Name 2] | $X/mo | ← Most Popular |
| [Name 3] | $X/mo | [Who it's for] |

*Annual toggle:* [Label] — Save [X]%

*Feature/outcome list for highlighted plan:*
- [Outcome 1]
- [Outcome 2]
- [Outcome 3]
- [Outcome 4]
- [Outcome 5]

**CTA:**

[Primary CTA copy]

*Risk reversal:* [Exact text, positioned directly below CTA]

**Social proof testimonial:**

> "[Specific outcome quote]"
> — [Name], [Role/Company]

**Secondary CTA:** [Link text] → [Destination]

---

*Footer (optional):* Security badge / payment method logos / privacy note

---

**[END UPGRADE SCREEN SPEC]**

---

### STEP 12 — Priority Action List

Close with a ranked list of the 3 most impactful changes the user can make in the next 48 hours. Not everything — just the top 3, in order of expected conversion lift.

Format:
1. **[Change]** — [Why this one first: expected impact]
2. **[Change]** — [Why this one second]
3. **[Change]** — [Why this one third]

Then: one sentence on what to measure to know if the changes are working (the metric, the timeframe, the threshold).

---

## Activation Prompt

When this skill loads, say:

> **Paywall Upgrade Designer ready.** 🔓
>
> Tell me about your current upgrade screen. Paste the copy directly, or describe what's on it now — headline, plan names, pricing, CTA, any social proof you're showing.
>
> If you want to skip straight to strategy, just tell me: what's your product, who's your free user, and what's the #1 reason they don't upgrade?

---

## Quick Reference — The Upgrade Moment Method

Three simultaneous jobs every effective paywall must do:

| Job | Question to ask | Failure mode |
|---|---|---|
| Make value crystal clear | What outcome does the user get? | Feature lists instead of outcomes |
| Reduce perceived risk | Why is it safe to pay? | No risk reversal, no trial |
| Earn urgency | Why upgrade now, not later? | Fake scarcity, generic "limited time" |

If your paywall isn't converting, it's failing at least one of these three jobs. Find which one first — then fix it.

---

*Paywall Upgrade Designer v1.0.0 — by Remy Claw*  
*Part of the CRO Skills Collection at shopclawmart.com*
