---
name: paytoll
description: "27 tools for DeFi, DEX swaps, cross-chain bridges, Twitter/X, on-chain token data, crypto utilities, and LLM access via x402 micro-payments on Base. No API keys needed — payment is the auth."
metadata: {"mcpServers":{"paytoll":{"command":"npx","args":["-y","paytoll-mcp"],"env":{"PRIVATE_KEY":"${PRIVATE_KEY}"}}}}
requires.env: ["PRIVATE_KEY"]
requires.bins: ["node"]
homepage: https://paytoll.io
repository: https://github.com/foodaka/paytoll-mcp
---

# PayToll

You have access to 27 tools for DeFi intelligence, DEX swaps, cross-chain bridges, social media, on-chain token data, crypto utilities, and LLM access via the PayToll MCP server. Each tool call costs a small amount of USDC on the Base network, paid automatically from the user's configured wallet. No API keys or subscriptions needed — payment is the auth.

## Setup Requirements

The user must have:
- A **dedicated** wallet private key set as `PRIVATE_KEY` in their environment (do not reuse your main wallet — use a wallet with minimal funds)
- USDC on the Base network in that wallet (a few dollars funds thousands of calls)
- A small amount of ETH on Base (for gas fees)

The private key never leaves your machine. It is only used locally to sign EIP-712 payment authorizations. It is never transmitted to any server.

## Security

- **No transaction execution.** Transaction-building tools (`aave-supply`, `swap-build`, etc.) return unsigned transaction data for review. They do not broadcast or execute anything on-chain.
- **Micro-payments only.** Most calls cost $0.001–$0.08. The wallet cannot be drained — each payment is a discrete, small authorization.
- **Open source.** The MCP server source is auditable at https://github.com/foodaka/paytoll-mcp

## Available Tools

### Aave DeFi Intelligence

Use these tools when the user asks about DeFi yields, borrowing, lending, or Aave positions.

**`aave-best-yield`** ($0.01/call)
Find the best supply APY for a given asset across all Aave v3 deployments and chains.
- Use when: "What's the best yield for USDC?", "Where should I supply ETH for the highest APY?"
- Input: `asset` (e.g., "USDC", "ETH", "WBTC")

**`aave-best-borrow`** ($0.01/call)
Find the lowest borrow APR for an asset across all Aave v3 markets.
- Use when: "Cheapest place to borrow DAI?", "What's the lowest ETH borrow rate?"
- Input: `asset` (e.g., "USDC", "ETH", "DAI")

**`aave-markets`** ($0.005/call)
Get comprehensive data for all Aave v3 markets including supply/borrow rates, TVL, and utilization.
- Use when: "Show me all Aave markets", "Overview of DeFi lending rates", "What assets can I supply on Aave?"

**`aave-health-factor`** ($0.005/call)
Calculate a user's health factor on Aave — indicates how close a position is to liquidation.
- Use when: "What's my health factor?", "Am I at risk of liquidation?", "Check health for 0x..."
- Input: `chainId`

**`aave-user-positions`** ($0.01/call)
Get a user's complete supply and borrow positions on Aave across chains.
- Use when: "What are my Aave positions?", "Show my DeFi portfolio", "What am I supplying/borrowing?"

### Aave Transactions

Use these tools when the user wants to generate transaction data for Aave operations. Returns unsigned transaction data — does not broadcast.

**`aave-supply`** ($0.01/call)
Build a supply (deposit) transaction for Aave.
- Use when: "Supply 100 USDC to Aave", "Deposit ETH into Aave"
- Input: `tokenAddress`, `amount`, `chainId`

**`aave-borrow`** ($0.01/call)
Build a borrow transaction for Aave.
- Use when: "Borrow 50 DAI from Aave", "Take a USDC loan on Aave"
- Input: `tokenAddress`, `amount`, `chainId`

**`aave-repay`** ($0.01/call)
Build a repay transaction for paying back Aave loans.
- Use when: "Repay my DAI loan", "Pay back 100 USDC on Aave"
- Input: `tokenAddress`, `chainId`, `amount` or `max: true`

**`aave-withdraw`** ($0.01/call)
Build a withdraw transaction for removing assets from Aave.
- Use when: "Withdraw my USDC from Aave", "Pull out my ETH supply"
- Input: `tokenAddress`, `chainId`, `amount` or `max: true`

### DEX Swaps & Cross-Chain Bridges

Powered by Li.Fi aggregator. Supports same-chain swaps and cross-chain bridges across 12 networks (Ethereum, Base, Arbitrum, Optimism, Polygon, Avalanche, BSC, zkSync, Linea, Scroll, Fantom, Gnosis). To bridge, set `fromChain` and `toChain` to different chain IDs — Li.Fi routes through optimal bridge protocols (Stargate, Across, Hop, etc.) automatically. Returns unsigned transaction data — does not broadcast.

**`swap-quote`** ($0.005/call)
Get a DEX swap or cross-chain bridge price quote.
- Use when: "How much USDC for 1 ETH?", "Quote bridging ETH from Ethereum to Arbitrum", "What's the swap rate?"
- Input: `fromChain`, `fromToken`, `toToken`, `amount`, optionally `toChain` (for cross-chain), `slippage`

**`swap-build`** ($0.01/call)
Build a swap or bridge transaction ready for signing.
- Use when: "Swap 1 ETH to USDC on Base", "Bridge 100 USDC from Ethereum to Arbitrum"
- Input: `fromChain`, `fromToken`, `toToken`, `amount`, optionally `toChain`, `slippage`

**`token-balance`** ($0.005/call)
Check wallet token balance on any supported chain.
- Use when: "What's my ETH balance?", "How much USDC do I have on Base?"
- Input: `chainId`, optionally `tokenAddress` (omit for native token)

### On-Chain Token Data

Use these tools for on-chain token analytics, pool discovery, and trending tokens.

**`onchain-token-data`** ($0.015/call)
Get comprehensive on-chain token data including price, supply, FDV, market cap, and top pools.
- Use when: "Tell me about this token", "What's the market cap of PEPE on Base?"
- Input: `network`, `contractAddress`

**`onchain-token-price`** ($0.015/call)
Get on-chain token price by contract address.
- Use when: "What's the price of this token on-chain?"
- Input: `network`, `contractAddress`

**`search-pools`** ($0.015/call)
Search liquidity pools by token name, symbol, or contract address across networks.
- Use when: "Find pools for PEPE", "Search for WETH liquidity pools"
- Input: `query`

**`trending-pools`** ($0.015/call)
Get trending liquidity pools on a network sorted by trading activity.
- Use when: "What's trending on Base?", "Show me hot pools on Ethereum"
- Input: `network` (e.g., "eth", "base", "solana", "arbitrum")

### Social (X / Twitter)

Use these tools when the user asks about tweets, Twitter users, or wants to post on X.

**`twitter-search`** ($0.08/call)
Search recent tweets from the last 7 days. Max 20 results per call.
- Use when: "Search Twitter for bitcoin", "What are people saying about ETH?", "Find tweets about Aave"
- Input: `query` (X API search syntax), `maxResults` (10-20), `sortOrder` ("recency" or "relevancy")

**`twitter-user-tweets`** ($0.08/call)
Get a user's recent tweets. Max 20 per call. Can exclude replies and retweets.
- Use when: "What has Vitalik tweeted recently?", "Show me Elon's latest tweets"
- Input: `userId`, `maxResults` (5-20), `excludeReplies`, `excludeRetweets`

**`twitter-tweet-lookup`** ($0.02/call)
Look up tweets by ID with metrics and author info. Max 10 tweets per call.
- Use when: "Show me this tweet", "Get details on tweet ID 123..."
- Input: `ids` (array of tweet ID strings)

**`twitter-user-lookup`** ($0.02/call)
Look up an X/Twitter user by username or user ID.
- Use when: "Who is @elonmusk?", "Look up this Twitter user", "Get profile for user ID 44196397"
- Input: `username` OR `userId` (exactly one)

**`twitter-post`** ($0.015/call)
Post a tweet using the user's own OAuth 2.0 access token. Supports replies and quote tweets.
- Use when: "Post this tweet for me", "Reply to this tweet"
- Input: `text`, `accessToken` (user's OAuth token), `replyToId` (optional), `quoteTweetId` (optional)
- Note: Requires the user's own X API OAuth token with `tweet.write` scope.

### Crypto Utilities

Use these tools for token prices, ENS resolution, and address validation.

**`crypto-price`** ($0.015/call)
Get real-time crypto prices from CoinGecko with optional market data.
- Use when: "Price of ETH?", "How much is BTC worth?", "What's SOL trading at?"
- Input: `symbol` (e.g., "BTC", "ETH", "SOL"), optionally `currency`, `includeMarketData`

**`ens-lookup`** ($0.001/call)
Resolve ENS names to Ethereum addresses and perform reverse lookups.
- Use when: "What address is vitalik.eth?", "Reverse lookup 0x..."
- Input: `name` (e.g., "vitalik.eth") OR `address`

**`wallet-validator`** ($0.0005/call)
Validate whether a string is a valid wallet address with checksum verification.
- Use when: "Is this a valid address?", "Check if 0x... is valid"
- Input: `address`, optionally `network` ("ethereum", "bitcoin", "solana")

### LLM Proxy

Use these tools when the user wants to query AI models through PayToll.

**`llm-openai`** ($0.01/call)
Query OpenAI models: GPT-4o, GPT-4o-mini, GPT-4 Turbo, GPT-3.5 Turbo, o3-mini.
- Input: `messages`, optionally `model`, `temperature`, `max_tokens`

**`llm-anthropic`** ($0.01/call)
Query Anthropic models: Claude Sonnet 4, Haiku 4, Claude 3.5 Sonnet, Claude 3.5 Haiku, Claude 3 Haiku.
- Input: `messages`, optionally `model`, `temperature`, `max_tokens`

**`llm-google`** ($0.01/call)
Query Google models: Gemini 2.0 Flash, Gemini 2.0 Flash Lite, Gemini 1.5 Pro, Gemini 1.5 Flash.
- Input: `messages`, optionally `model`, `temperature`, `max_tokens`

## Usage Guidelines

- Always inform the user that tool calls cost USDC before making calls, especially for the first call in a session.
- For multi-step research (e.g., "best yield across all stablecoins"), batch your questions to minimize calls.
- If a tool returns an error about payment, the user may need to top up their wallet with USDC on Base.
- Transaction-building tools return unsigned data — remind the user they need to sign and broadcast separately.
- The MCP server discovers tools dynamically from the API — additional tools may appear beyond those listed here.

## Pricing Summary

| Tool | Cost |
|------|------|
| `aave-best-yield` | $0.01 |
| `aave-best-borrow` | $0.01 |
| `aave-markets` | $0.005 |
| `aave-health-factor` | $0.005 |
| `aave-user-positions` | $0.01 |
| `aave-supply` | $0.01 |
| `aave-borrow` | $0.01 |
| `aave-repay` | $0.01 |
| `aave-withdraw` | $0.01 |
| `swap-quote` | $0.005 |
| `swap-build` | $0.01 |
| `token-balance` | $0.005 |
| `onchain-token-data` | $0.015 |
| `onchain-token-price` | $0.015 |
| `search-pools` | $0.015 |
| `trending-pools` | $0.015 |
| `twitter-search` | $0.08 |
| `twitter-user-tweets` | $0.08 |
| `twitter-tweet-lookup` | $0.02 |
| `twitter-user-lookup` | $0.02 |
| `twitter-post` | $0.015 |
| `crypto-price` | $0.015 |
| `ens-lookup` | $0.001 |
| `wallet-validator` | $0.0005 |
| `llm-openai` | $0.01 |
| `llm-anthropic` | $0.01 |
| `llm-google` | $0.01 |
