---
name: stripe
description: Query Stripe customer and billing data from a synced PostgreSQL database. Use when the user asks about Stripe customers, subscriptions, invoices, charges, or any Stripe-related data.
---

All the stripe data is sync in a postgresdb. You can query this db via exec by simply running ./query.sh "SELECT now();"

all the tables are under "stripe" schema and these are the tables:

CREATE TABLE stripe.accounts (
    _raw_data jsonb NOT NULL,
    first_synced_at timestamp with time zone DEFAULT now() NOT NULL,
    _last_synced_at timestamp with time zone DEFAULT now() NOT NULL,
    _updated_at timestamp with time zone DEFAULT now() NOT NULL,
    business_name text,
    email text,
    type text,
    charges_enabled boolean,
    payouts_enabled boolean,
    details_submitted boolean,
    country text,
    default_currency text,
    created integer,
    api_key_hashes text[] DEFAULT '{}'::text[],
    id text,
);

CREATE TABLE stripe.active_entitlements (
    _updated_at timestamp with time zone DEFAULT timezone('utc'::text, now()) NOT NULL,
    _last_synced_at timestamp with time zone,
    _raw_data jsonb,
    _account_id text NOT NULL,
    object text,
    livemode boolean,
    feature text,
    customer text,
    lookup_key text,
    id text,
);

CREATE TABLE stripe.balance_transactions (
    _raw_data jsonb NOT NULL,
    _last_synced_at timestamp with time zone,
    _updated_at timestamp with time zone DEFAULT now(),
    _account_id text NOT NULL,
    id text,
    object text,
    amount bigint,
    available_on integer,
    created integer,
    currency text,
    description text,
    exchange_rate numeric,
    fee bigint,
    fee_details jsonb,
    net bigint,
    reporting_category text,
    source text,
    status text,
    type text,
);

CREATE TABLE stripe.charges (
    _updated_at timestamp with time zone DEFAULT timezone('utc'::text, now()) NOT NULL,
    _last_synced_at timestamp with time zone,
    _raw_data jsonb,
    _account_id text NOT NULL,
    object text,
    paid boolean,
    "order" text,
    amount bigint,
    review text,
    source jsonb,
    status text,
    created integer,
    dispute text,
    invoice text,
    outcome jsonb,
    refunds jsonb,
    updated integer,
    captured boolean,
    currency text,
    customer text,
    livemode boolean,
    metadata jsonb,
    refunded boolean,
    shipping jsonb,
    application text,
    description text,
    destination text,
    failure_code text,
    on_behalf_of text,
    fraud_details jsonb,
    receipt_email text,
    payment_intent text,
    receipt_number text,
    transfer_group text,
    amount_refunded bigint,
    application_fee text,
    failure_message text,
    source_transfer text,
    balance_transaction text,
    statement_descriptor text,
    payment_method_details jsonb,
    id text,
);

CREATE TABLE stripe.checkout_session_line_items (
    _updated_at timestamp with time zone DEFAULT timezone('utc'::text, now()) NOT NULL,
    _last_synced_at timestamp with time zone,
    _raw_data jsonb,
    _account_id text NOT NULL,
    object text,
    currency text,
    description text,
    price text,
    quantity integer,
    checkout_session text,
    id text,
    amount_discount bigint,
    amount_subtotal bigint,
    amount_tax bigint,
    amount_total bigint,
);

CREATE TABLE stripe.checkout_sessions (
    _updated_at timestamp with time zone DEFAULT timezone('utc'::text, now()) NOT NULL,
    _last_synced_at timestamp with time zone,
    _raw_data jsonb,
    _account_id text NOT NULL,
    object text,
    adaptive_pricing jsonb,
    after_expiration jsonb,
    allow_promotion_codes boolean,
    automatic_tax jsonb,
    billing_address_collection text,
    cancel_url text,
    client_reference_id text,
    client_secret text,
    collected_information jsonb,
    consent jsonb,
    consent_collection jsonb,
    created integer,
    currency text,
    currency_conversion jsonb,
    custom_fields jsonb,
    custom_text jsonb,
    customer text,
    customer_creation text,
    customer_details jsonb,
    customer_email text,
    discounts jsonb,
    expires_at integer,
    invoice text,
    invoice_creation jsonb,
    livemode boolean,
    locale text,
    metadata jsonb,
    mode text,
    optional_items jsonb,
    payment_intent text,
    payment_link text,
    payment_method_collection text,
    payment_method_configuration_details jsonb,
    payment_method_options jsonb,
    payment_method_types jsonb,
    payment_status text,
    permissions jsonb,
    phone_number_collection jsonb,
    presentment_details jsonb,
    recovered_from text,
    redirect_on_completion text,
    return_url text,
    saved_payment_method_options jsonb,
    setup_intent text,
    shipping_address_collection jsonb,
    shipping_cost jsonb,
    shipping_details jsonb,
    shipping_options jsonb,
    status text,
    submit_type text,
    subscription text,
    success_url text,
    tax_id_collection jsonb,
    total_details jsonb,
    ui_mode text,
    url text,
    wallet_options jsonb,
    id text,
    amount_subtotal bigint,
    amount_total bigint,
);

CREATE TABLE stripe.coupons (
    _updated_at timestamp with time zone DEFAULT timezone('utc'::text, now()) NOT NULL,
    _last_synced_at timestamp with time zone,
    _raw_data jsonb,
    object text,
    name text,
    valid boolean,
    created integer,
    updated integer,
    currency text,
    duration text,
    livemode boolean,
    metadata jsonb,
    redeem_by integer,
    amount_off bigint,
    percent_off double precision,
    times_redeemed bigint,
    max_redemptions bigint,
    duration_in_months bigint,
    percent_off_precise double precision,
    id text,
);

CREATE TABLE stripe.credit_notes (
    _last_synced_at timestamp with time zone,
    _raw_data jsonb,
    _account_id text NOT NULL,
    object text,
    created integer,
    currency text,
    customer text,
    customer_balance_transaction text,
    discount_amounts jsonb,
    invoice text,
    lines jsonb,
    livemode boolean,
    memo text,
    metadata jsonb,
    number text,
    pdf text,
    reason text,
    refund text,
    shipping_cost jsonb,
    status text,
    tax_amounts jsonb,
    type text,
    voided_at text,
    id text,
    amount bigint,
    amount_shipping bigint,
    discount_amount bigint,
    out_of_band_amount bigint,
    subtotal bigint,
    subtotal_excluding_tax bigint,
    total bigint,
    total_excluding_tax bigint,
);

CREATE TABLE stripe.customers (
    _updated_at timestamp with time zone DEFAULT timezone('utc'::text, now()) NOT NULL,
    _last_synced_at timestamp with time zone,
    _raw_data jsonb,
    _account_id text NOT NULL,
    object text,
    address jsonb,
    description text,
    email text,
    metadata jsonb,
    name text,
    phone text,
    shipping jsonb,
    created integer,
    currency text,
    default_source text,
    delinquent boolean,
    discount jsonb,
    invoice_prefix text,
    invoice_settings jsonb,
    livemode boolean,
    next_invoice_sequence integer,
    preferred_locales jsonb,
    tax_exempt text,
    deleted boolean,
    id text,
    balance bigint,
);

CREATE TABLE stripe.disputes (
    _updated_at timestamp with time zone DEFAULT timezone('utc'::text, now()) NOT NULL,
    _last_synced_at timestamp with time zone,
    _raw_data jsonb,
    _account_id text NOT NULL,
    object text,
    amount bigint,
    charge text,
    reason text,
    status text,
    created integer,
    updated integer,
    currency text,
    evidence jsonb,
    livemode boolean,
    metadata jsonb,
    evidence_details jsonb,
    balance_transactions jsonb,
    is_charge_refundable boolean,
    payment_intent text,
    id text,
);

CREATE TABLE stripe.early_fraud_warnings (
    _updated_at timestamp with time zone DEFAULT timezone('utc'::text, now()) NOT NULL,
    _last_synced_at timestamp with time zone,
    _raw_data jsonb,
    _account_id text NOT NULL,
    object text,
    actionable boolean,
    charge text,
    created integer,
    fraud_type text,
    livemode boolean,
    payment_intent text,
    id text,
);

CREATE TABLE stripe.events (
    _updated_at timestamp with time zone DEFAULT timezone('utc'::text, now()) NOT NULL,
    _last_synced_at timestamp with time zone,
    _raw_data jsonb,
    object text,
    data jsonb,
    type text,
    created integer,
    request text,
    updated integer,
    livemode boolean,
    api_version text,
    pending_webhooks bigint,
    id text,
);

CREATE TABLE stripe.exchange_rates_from_usd (
    _raw_data jsonb NOT NULL,
    _last_synced_at timestamp with time zone,
    _updated_at timestamp with time zone DEFAULT now(),
    _account_id text NOT NULL,
    date date NOT NULL,
    sell_currency text NOT NULL,
    buy_currency_exchange_rates text,
);

CREATE TABLE stripe.features (
    _updated_at timestamp with time zone DEFAULT timezone('utc'::text, now()) NOT NULL,
    _last_synced_at timestamp with time zone,
    _raw_data jsonb,
    _account_id text NOT NULL,
    object text,
    livemode boolean,
    name text,
    lookup_key text,
    active boolean,
    metadata jsonb,
    id text,
);

CREATE TABLE stripe.invoices (
    _updated_at timestamp with time zone DEFAULT timezone('utc'::text, now()) NOT NULL,
    _last_synced_at timestamp with time zone,
    _raw_data jsonb,
    _account_id text NOT NULL,
    object text,
    auto_advance boolean,
    collection_method text,
    currency text,
    description text,
    hosted_invoice_url text,
    lines jsonb,
    period_end integer,
    period_start integer,
    status text,
    total bigint,
    account_country text,
    account_name text,
    account_tax_ids jsonb,
    amount_due bigint,
    amount_paid bigint,
    amount_remaining bigint,
    application_fee_amount bigint,
    attempt_count integer,
    attempted boolean,
    billing_reason text,
    created integer,
    custom_fields jsonb,
    customer_address jsonb,
    customer_email text,
    customer_name text,
    customer_phone text,
    customer_shipping jsonb,
    customer_tax_exempt text,
    customer_tax_ids jsonb,
    default_tax_rates jsonb,
    discount jsonb,
    discounts jsonb,
    due_date integer,
    footer text,
    invoice_pdf text,
    last_finalization_error jsonb,
    livemode boolean,
    next_payment_attempt integer,
    number text,
    paid boolean,
    payment_settings jsonb,
    receipt_number text,
    statement_descriptor text,
    status_transitions jsonb,
    total_discount_amounts jsonb,
    total_tax_amounts jsonb,
    transfer_data jsonb,
    webhooks_delivered_at integer,
    customer text,
    subscription text,
    payment_intent text,
    default_payment_method text,
    default_source text,
    on_behalf_of text,
    charge text,
    metadata jsonb,
    id text,
    ending_balance bigint,
    starting_balance bigint,
    subtotal bigint,
    tax bigint,
    post_payment_credit_notes_amount bigint,
    pre_payment_credit_notes_amount bigint,
);

CREATE TABLE stripe.payment_intents (
    _last_synced_at timestamp with time zone,
    _raw_data jsonb,
    _account_id text NOT NULL,
    object text,
    amount_details jsonb,
    application text,
    automatic_payment_methods text,
    canceled_at integer,
    cancellation_reason text,
    capture_method text,
    client_secret text,
    confirmation_method text,
    created integer,
    currency text,
    customer text,
    description text,
    invoice text,
    last_payment_error text,
    livemode boolean,
    metadata jsonb,
    next_action text,
    on_behalf_of text,
    payment_method text,
    payment_method_options jsonb,
    payment_method_types jsonb,
    processing text,
    receipt_email text,
    review text,
    setup_future_usage text,
    shipping jsonb,
    statement_descriptor text,
    statement_descriptor_suffix text,
    status text,
    transfer_data jsonb,
    transfer_group text,
    id text,
    amount bigint,
    amount_capturable bigint,
    amount_received bigint,
    application_fee_amount bigint,
);

CREATE TABLE stripe.payment_methods (
    _last_synced_at timestamp with time zone,
    _raw_data jsonb,
    _account_id text NOT NULL,
    object text,
    created integer,
    customer text,
    type text,
    billing_details jsonb,
    metadata jsonb,
    card jsonb,
    id text,
);

CREATE TABLE stripe.payouts (
    _updated_at timestamp with time zone DEFAULT timezone('utc'::text, now()) NOT NULL,
    _last_synced_at timestamp with time zone,
    _raw_data jsonb,
    object text,
    date text,
    type text,
    amount bigint,
    method text,
    status text,
    created integer,
    updated integer,
    currency text,
    livemode boolean,
    metadata jsonb,
    automatic boolean,
    recipient text,
    description text,
    destination text,
    source_type text,
    arrival_date text,
    bank_account jsonb,
    failure_code text,
    transfer_group text,
    amount_reversed bigint,
    failure_message text,
    source_transaction text,
    balance_transaction text,
    statement_descriptor text,
    statement_description text,
    failure_balance_transaction text,
    id text,
);

CREATE TABLE stripe.plans (
    _updated_at timestamp with time zone DEFAULT timezone('utc'::text, now()) NOT NULL,
    _last_synced_at timestamp with time zone,
    _raw_data jsonb,
    _account_id text NOT NULL,
    object text,
    name text,
    tiers jsonb,
    active boolean,
    amount bigint,
    created integer,
    product text,
    updated integer,
    currency text,
    "interval" text,
    livemode boolean,
    metadata jsonb,
    nickname text,
    tiers_mode text,
    usage_type text,
    billing_scheme text,
    interval_count bigint,
    aggregate_usage text,
    transform_usage text,
    trial_period_days bigint,
    statement_descriptor text,
    statement_description text,
    id text,
);

CREATE TABLE stripe.prices (
    _updated_at timestamp with time zone DEFAULT timezone('utc'::text, now()) NOT NULL,
    _last_synced_at timestamp with time zone,
    _raw_data jsonb,
    _account_id text NOT NULL,
    object text,
    active boolean,
    currency text,
    metadata jsonb,
    nickname text,
    recurring jsonb,
    type text,
    billing_scheme text,
    created integer,
    livemode boolean,
    lookup_key text,
    tiers_mode text,
    transform_quantity jsonb,
    unit_amount_decimal text,
    product text,
    id text,
    unit_amount bigint,
);

CREATE TABLE stripe.products (
    _updated_at timestamp with time zone DEFAULT timezone('utc'::text, now()) NOT NULL,
    _last_synced_at timestamp with time zone,
    _raw_data jsonb,
    _account_id text NOT NULL,
    object text,
    active boolean,
    default_price text,
    description text,
    metadata jsonb,
    name text,
    created integer,
    images jsonb,
    marketing_features jsonb,
    livemode boolean,
    package_dimensions jsonb,
    shippable boolean,
    statement_descriptor text,
    unit_label text,
    updated integer,
    url text,
    id text,
);

CREATE TABLE stripe.refunds (
    _updated_at timestamp with time zone DEFAULT timezone('utc'::text, now()) NOT NULL,
    _last_synced_at timestamp with time zone,
    _raw_data jsonb,
    _account_id text NOT NULL,
    object text,
    balance_transaction text,
    charge text,
    created integer,
    currency text,
    destination_details jsonb,
    metadata jsonb,
    payment_intent text,
    reason text,
    receipt_number text,
    source_transfer_reversal text,
    status text,
    transfer_reversal text,
    id text,
    amount bigint,
);

CREATE TABLE stripe.reviews (
    _updated_at timestamp with time zone DEFAULT timezone('utc'::text, now()) NOT NULL,
    _last_synced_at timestamp with time zone,
    _raw_data jsonb,
    _account_id text NOT NULL,
    object text,
    billing_zip text,
    charge text,
    created integer,
    closed_reason text,
    livemode boolean,
    ip_address text,
    ip_address_location jsonb,
    open boolean,
    opened_reason text,
    payment_intent text,
    reason text,
    session text,
    id text,
);

CREATE TABLE stripe.setup_intents (
    _last_synced_at timestamp with time zone,
    _raw_data jsonb,
    _account_id text NOT NULL,
    object text,
    created integer,
    customer text,
    description text,
    payment_method text,
    status text,
    usage text,
    cancellation_reason text,
    latest_attempt text,
    mandate text,
    single_use_mandate text,
    on_behalf_of text,
    id text,
);

CREATE TABLE stripe.subscription_item_change_events_v2_beta (
    _raw_data jsonb NOT NULL,
    _last_synced_at timestamp with time zone,
    _updated_at timestamp with time zone DEFAULT now(),
    _account_id text NOT NULL,
    event_timestamp timestamp with time zone NOT NULL,
    event_type text NOT NULL,
    subscription_item_id text NOT NULL,
    currency text,
    mrr_change bigint,
    quantity_change bigint,
    subscription_id text,
    customer_id text,
    price_id text,
    product_id text,
    local_event_timestamp text,
);

CREATE TABLE stripe.subscription_items (
    _last_synced_at timestamp with time zone,
    _raw_data jsonb,
    _account_id text NOT NULL,
    object text,
    billing_thresholds jsonb,
    created integer,
    deleted boolean,
    metadata jsonb,
    quantity integer,
    price text,
    subscription text,
    tax_rates jsonb,
    current_period_end integer,
    current_period_start integer,
    id text,
);

CREATE TABLE stripe.subscription_schedules (
    _last_synced_at timestamp with time zone,
    _raw_data jsonb,
    _account_id text NOT NULL,
    object text,
    application text,
    canceled_at integer,
    completed_at integer,
    created integer,
    current_phase jsonb,
    customer text,
    default_settings jsonb,
    end_behavior text,
    livemode boolean,
    metadata jsonb,
    phases jsonb,
    released_at integer,
    released_subscription text,
    status text,
    subscription text,
    test_clock text,
    id text,
);

CREATE TABLE stripe.subscriptions (
    _updated_at timestamp with time zone DEFAULT timezone('utc'::text, now()) NOT NULL,
    _last_synced_at timestamp with time zone,
    _raw_data jsonb,
    _account_id text NOT NULL,
    object text,
    cancel_at_period_end boolean,
    current_period_end integer,
    current_period_start integer,
    default_payment_method text,
    items jsonb,
    metadata jsonb,
    pending_setup_intent text,
    pending_update jsonb,
    status text,
    application_fee_percent double precision,
    billing_cycle_anchor integer,
    billing_thresholds jsonb,
    cancel_at integer,
    canceled_at integer,
    collection_method text,
    created integer,
    days_until_due integer,
    default_source text,
    default_tax_rates jsonb,
    discount jsonb,
    ended_at integer,
    livemode boolean,
    next_pending_invoice_item_invoice integer,
    pause_collection jsonb,
    pending_invoice_item_interval jsonb,
    start_date integer,
    transfer_data jsonb,
    trial_end jsonb,
    trial_start jsonb,
    schedule text,
    customer text,
    latest_invoice text,
    plan text,
    id text,
);
CREATE TABLE stripe.tax_ids (
    _last_synced_at timestamp with time zone,
    _raw_data jsonb,
    _account_id text NOT NULL,
    object text,
    country text,
    customer text,
    type text,
    value text,
    created integer,
    livemode boolean,
    owner jsonb,
    id text,
);
