# Payment Security

## Card Lost or Stolen

**Immediately:**
1. Freeze card in app (most banks have instant freeze)
2. Call bank's fraud line (number on back of card or bank website)
3. Review recent transactions for unauthorized charges
4. Request replacement card

**After:**
- Update autopay with new card number
- Check credit report in 30 days

## Suspicious Charge Appeared

**Before panicking:**
1. Check if it's a merchant name you don't recognize (many use parent company names)
2. Check if family member made purchase
3. Check subscriptions you forgot about

**If truly unauthorized:**
1. Don't contact the merchant (they may be the scammer)
2. Call your bank's fraud department
3. They'll investigate and issue provisional credit

## Fraud Red Flags

**Never do these:**
- Give card number to unsolicited callers ("We're calling from your bank")
- Pay for anything via gift cards (100% scam indicator)
- Click links in fraud alert texts (go to bank app directly)
- Wire money to "fix" a problem
- Pay someone who overpaid you and wants difference back

**Legitimate fraud alerts:**
- Come from number you recognize OR
- Ask you to call number on back of card
- Never ask for full card number (bank already has it)
- Never pressure you to act immediately

## Card Declined

**Common reasons:**
- Over credit limit
- Fraud system flagged unusual purchase
- Card expired
- International purchase not pre-notified

**Quick fixes:**
- Try smaller amount (if near limit)
- Call bank / approve in app (if fraud flag)
- Try different card as backup

## Online Payment Safety

**Safer:**
- Virtual card numbers (Capital One, Citi offer these)
- PayPal (hides card from merchant)
- Apple Pay / Google Pay (tokenized)

**Check before entering card:**
- URL starts with https://
- Site isn't a typo of real site (amaz0n.com)
- Payment page isn't an iframe from random domain

## If Data Breach Affects You

1. Change password for that site
2. Watch statements closely for 90 days
3. Consider freezing credit (free at all bureaus)
4. Don't panic — banks usually catch fraud quickly
