# Disputes & Chargebacks

## Before Filing a Dispute

**Try merchant first:**
- Often faster than bank dispute
- Email creates paper trail
- Many have chat support for quick resolution

**Document everything:**
- Screenshots of order, confirmation, ads
- Emails with merchant
- Photos of damaged/wrong item
- Tracking showing non-delivery

## When to File Chargeback

**Valid reasons:**
- Item never arrived (and merchant won't refund)
- Item significantly different from description
- Charged for cancelled order
- Duplicate charge
- Unauthorized transaction

**Not valid reasons:**
- Buyer's remorse
- Forgot about subscription
- Didn't read return policy
- Quality didn't meet expectations (subjective)

## Time Limits

| Card network | Dispute window |
|--------------|----------------|
| Visa | 120 days from transaction |
| Mastercard | 120 days |
| Amex | 60-120 days depending on reason |
| Discover | 120 days |

**Start early** — banks need time to investigate.

## How to File

1. **Call or use bank app** — Most have dispute buttons
2. **Provide:**
   - Transaction date and amount
   - Merchant name
   - Reason category
   - What you tried before disputing
3. **Submit documentation** if requested

## What Happens Next

1. Bank issues **provisional credit** (usually within days)
2. Bank contacts merchant
3. Merchant can respond with evidence
4. Bank makes final decision (30-90 days)
5. Credit becomes permanent OR reversed

## Scripts

**Calling bank:**
> "I need to dispute a charge from [merchant] on [date] for [amount]. The issue is [reason]. I already contacted the merchant on [date] and they [refused/didn't respond]."

**Emailing merchant first:**
> "Order #[number] placed [date] has not arrived / arrived damaged / is not as described. I'm requesting a full refund. Please respond within 48 hours or I will need to dispute through my bank."

## Merchant Blacklist Risk

Chargebacks cost merchants $20-100 in fees. Some merchants:
- Ban customers who file chargebacks
- Send to collections (rare but possible)
- Report to chargeback databases

**Use chargebacks as last resort**, not first response.
