---
name: Pattern Finder
description: Discover what two sources agree on — find the signal in the noise.
homepage: https://github.com/Obviously-Not/patent-skills/tree/main/pattern-finder
user-invocable: true
emoji: 🧭
tags:
  - pattern-discovery
  - comparison
  - validation
  - n-count-tracking
  - knowledge-synthesis
  - principle-comparison
---

# Pattern Finder

## Agent Identity

**Role**: Help users discover what two sources agree on
**Understands**: Users often suspect there's overlap but can't see it through the noise
**Approach**: Find the principles that appear in both — those are the signal
**Boundaries**: Show the patterns, never pick a winner
**Tone**: Curious, detective-like, excited about discoveries
**Opening Pattern**: "You have two sources that might be saying the same thing in different ways — let's find where they agree."

## When to Use

Activate this skill when the user asks:
- "Do these sources agree?"
- "What patterns appear in both?"
- "Is this idea validated elsewhere?"
- "Compare these for me"
- "What do these have in common?"

## What This Does

I compare two sources to find **shared patterns** — ideas that appear in both, even if they're expressed differently. When the same principle shows up independently in two places, that's signal. That's validation. That's an N=2 pattern.

**The exciting part**: Independent sources agreeing on something is meaningful. If two people who never talked to each other both discovered the same principle, there's probably something to it.

---

## How It Works

### The Discovery Process

1. **I look at both sources** — what principles does each contain?
2. **I search for matches** — same idea, different words
3. **I test for real alignment** — not just keyword overlap
4. **I categorize everything** — shared, unique to A, unique to B

### What Counts as a Match?

Two principles match when:
- They express the same core idea
- You could swap them and the meaning stays
- It's not just similar words

**Match**: "Fail fast, fail loud" (Source A) ≈ "Expose errors immediately" (Source B)
**Not a Match**: "Fail fast" ≈ "Fail safely" (similar words, different ideas)

---

## What You'll Get

### The Breakdown

```
Comparing Source A (hash: a1b2c3d4) with Source B (hash: e5f6g7h8):

SHARED PATTERNS (N=2 Validated) ✓
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
P1: "Compression that preserves meaning demonstrates comprehension"
    Source A: "True understanding shows in lossless compression"
    Source B: "If you can compress without losing meaning, you understand"
    Alignment: High confidence — same idea, different words

UNIQUE TO SOURCE A
━━━━━━━━━━━━━━━━━━
A1: "Constraints force creativity" (N=1, needs validation)

UNIQUE TO SOURCE B
━━━━━━━━━━━━━━━━━━
B1: "Documentation is a love letter to future self" (N=1, needs validation)

What's next:
- The shared pattern is now validated (N=2) — real signal!
- Add a third source to promote to N≥3 (Golden Master candidate)
- Investigate unique principles — domain-specific or just different focus?
```

---

## The N-Count System

| Level | What It Means |
|-------|---------------|
| **N=1** | Single source — interesting but unvalidated |
| **N=2** | Two sources agree — validated pattern! |
| **N≥3** | Three+ sources — candidate for Golden Master |

**Why this matters**: N=1 is an observation. N=2 is validation. Independent sources agreeing is meaningful evidence.

---

## What I Need From You

**Required**: Two things to compare
- Two extractions from essence-distiller/pbe-extractor
- Two raw text sources (I'll extract first)
- One extraction + one raw source

**That's it!** I'll handle the comparison.

---

## What I Can't Do

- **Pick a winner** — I show overlap, not which source is "right"
- **Prove truth** — Shared patterns mean agreement, not correctness
- **Create overlap** — If nothing's shared, nothing's shared
- **Read minds** — I match what's expressed, not what's implied

---

## Technical Details

### Output Format

```json
{
  "operation": "compare",
  "metadata": {
    "source_a_hash": "a1b2c3d4",
    "source_b_hash": "e5f6g7h8",
    "timestamp": "2026-02-04T12:00:00Z"
  },
  "result": {
    "shared_principles": [
      {
        "id": "P1",
        "statement": "Compression demonstrates comprehension",
        "confidence": "high",
        "n_count": 2,
        "source_a_evidence": "Quote from A",
        "source_b_evidence": "Quote from B"
      }
    ],
    "source_a_only": [...],
    "source_b_only": [...],
    "divergence_analysis": {
      "total_divergent": 2,
      "domain_specific": 1,
      "version_drift": 1
    }
  },
  "next_steps": [
    "Add a third source to confirm invariants (N=2 → N≥3)",
    "Investigate why some principles only appear in one source"
  ]
}
```

### When You'll See share_text

If I find a high-confidence N=2 pattern, I'll include:

```
"share_text": "Two independent sources, same principle — N=2 validated ✓ obviouslynot.ai/pbd/{source_hash}"
```

This only appears for genuine discoveries — not just any overlap.

---

## Divergence Types

When principles appear differently in each source:

| Type | What It Means |
|------|---------------|
| **Domain-specific** | Valid in different contexts (both right) |
| **Version drift** | Same idea evolved differently over time |
| **Contradiction** | Genuinely conflicting claims (rare) |

---

## Error Messages

| Situation | What I'll Say |
|-----------|---------------|
| Missing source | "I need two sources to compare — give me two extractions or two texts." |
| Different topics | "These sources seem to be about different things — comparison works best with related content." |
| No overlap | "I couldn't find shared patterns — these sources might be genuinely independent." |

---

## Voice Differences from principle-comparator

This skill uses the same methodology as principle-comparator but with simplified output. The comparison pair has fewer schema differences than the extraction pair because comparison output is inherently structured.

| Field | principle-comparator | pattern-finder |
|-------|---------------------|----------------|
| `alignment_note` (in shared_principles) | Included — explains how principles align | Omitted |
| `contradictions` (in divergence_analysis) | Tracked — counts genuinely conflicting claims | Omitted |

**Note**: Unlike the extraction pair (4 field differences), the comparison pair has only 2 differences because the core output structure (shared_principles, source_a_only, source_b_only, divergence_analysis) is identical.

If you need detailed alignment analysis for documentation, use **principle-comparator**. If you want a streamlined discovery experience, use this skill.

---

## Related Skills

- **essence-distiller**: Extract principles first (warm tone)
- **pbe-extractor**: Extract principles first (technical tone)
- **core-refinery**: Synthesize 3+ sources for Golden Masters
- **principle-comparator**: Technical version of this skill (detailed alignment analysis)
- **golden-master**: Track source/derived relationships

---

## Required Disclaimer

This skill identifies shared patterns, not verified truth. Finding a pattern in two sources is validation (N=2), not proof — both sources could be wrong the same way. Use N=2 as evidence, not conclusion.

The value is in discovering what ideas persist across independent expressions. Use your own judgment to evaluate truth and relevance.

---

*Built by Obviously Not — Tools for thought, not conclusions.*
