# Pathé API Reference

All requests must include a user-agent header that mimics a browser and accept JSON responses:

```
User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36
Accept: application/json
```

## Search (`/api/search/full?q={query}`)
- Returns a JSON array of movie/show objects.
- Each entry has `slug`, `title`, `poster` (and/or `posterPath`), `contentRating`, `synopsis`, `genres`, `duration`, `id`, `rating`, and `warning`.
- Preprocess the query to strip filler words (`the`, `a`, `an`, `of`, `in`, `on`, `for`, `and`) before hitting the API; this helps matching.
- Use difflib-style fuzzy matching on the `title` when multiple results appear.

## Show Details (`/api/show/{slug}?language=nl`)
- Use the slug from search results as the canonical identifier.
- Key fields:
  - `contentRating.description` (age/content rating description)
  - `synopsis` (detailed description; may be null)
  - `posterPath.lg` (big poster)
  - `backgroundPath` / `trailers` for extra context
- The response also contains `next24ShowtimesCount`, `genres`, `directors`, and `actors` for context.

## Cinema List (`/api/show/{slug}/cinemas?language=nl`)
- Returns an object whose keys are cinema slugs (e.g., `pathe-zaandam`).
- The value for each cinema includes metadata about which formats/services are available.
- Filter this list against the approved cinemas in `config/pathe_movie_config.json` unless the user explicitly requests other cinemas.

## Cinema Details (`/api/cinema/{cinema}?language=nl`)
- Provides `name`, `citySlug`, `services`, `alerts`, and parking/access information for each cinema.
- Use `citySlug` when the slug does not include a readable city name (e.g., `pathe-arena`).

## Showtimes (`/api/show/{slug}/showtimes/{cinema}?language=en`)
- Responses are keyed by date (`2026-02-05`) with each value being an array of showtime objects.
- Individual showtimes include `time`, `screen`, and occasionally `format`/`language` fields.
- When the array is empty, there are currently no sessions at that cinema.

## Full Shows List (`/api/shows?language=nl`)
- Returns all current Pathé entries; useful for auditing genre, rating, and posterPath fields.
- We inspected this to confirm that the API returns `slug`, `posterPath`, `contentRating`, `genres`, `next24ShowtimesCount`, and `showRef`.
