---
name: pathe-movie
description: Lookup Pathé Netherlands movies, posters, descriptions, cinemas, and showtimes via the Pathé JSON APIs. Trigger when the user mentions a Pathé movie/show, wants a poster, asks about a description/rating, or requests showtimes for a specific cinema.
---

# Pathé Movie Skill

## Summary
- Always talk to the `https://www.pathe.nl/api` endpoints with the required browserlike headers (see `scripts/pathe_movie.py`).
- Use the config at `config/pathe_movie_config.json` to know which cinemas to assume unless the user explicitly names a different cinema.
- Rely on `scripts/pathe_movie.py` for reusable helpers (sanitizing queries, fuzzy matching, best-match selection, and fetching downstream endpoints).
- When uncertain, reference `references/api.md` for payload shape, field names, and expected response structures.

## Search flow
1. Clean the user’s movie name by removing filler words (`the`, `a`, `an`, `of`, `in`, `on`, `for`, `and`).
2. Call `/api/search/full?q=...` with the sanitized query.
3. If multiple entries return, run a fuzzy title match (difflib) to pick the closest `title`. Keep the `slug`, `poster` (use `poster.lg`), and `contentRating` fields for later requests.
4. If a poster is required, return the `poster.lg` URL (fall back to `poster.md`/`posterPath` when necessary).

## Movie detail flow
- Given a slug, call `/api/show/{slug}?language=nl`.
- Pull `contentRating.description` and `synopsis` (some entries have `null`; handle gracefully) plus any extras such as `genres`, `directors`, `actors`, and `trailers` as context.
- Poster references now live under `posterPath` before falling back to the search response’s `poster`.

## Cinema flow
- Query `/api/show/{slug}/cinemas?language=nl`. Filter the returned cinema keys against `approvedCinemas` in the config unless the user asks for others.
- For each cinema we need more detail about, call `/api/cinema/{cinema}?language=nl` to fetch the official `name`, `citySlug`, and `services`/`alerts` metadata.

## Showtimes
- Use `/api/show/{slug}/showtimes/{cinema}?language=en` to get schedules. Responses are dictionaries keyed by date (`YYYY-MM-DD`). Each value is an array of showtimes; every entry contains at least a `time` string (plus `screen`, optional `language`, `format`, etc.).
- If the array is empty, return a note that there are currently no scheduled showings.

## Testing notes
- Ran `/api/search/full?q=matrix` to confirm the payload includes `slug`, `title`, `poster`, `contentRating`, and `genres`.
- Called `/api/show/the-matrix-41119` to verify `contentRating.description`, `synopsis`, and `posterPath` fields; the synopsis can be null and the posterPath may be missing, so always null-check.
- Queried `/api/cinema/pathe-zaandam` to inspect the returned `name`, `citySlug`, and service metadata (there is no `shows` list, so the cinema object is mostly static info).
- Hit `/api/show/iron-lung-51335/showtimes/pathe-zaandam` to confirm the endpoint returns a list; it was empty for that slug, showing you must handle zero-showtime responses.
- Pulled `/api/shows?language=nl` to understand the bulk structure: dozens of entries with `slug`, `posterPath`, `contentRating`, `genres`, and `next24ShowtimesCount`.

## Media delivery notes
- Always download poster images (and extra stills) locally before sending them through WhatsApp. Save them under `/tmp` or another temporary location so the gateway can read the file.
- When the user explicitly requests a poster via WhatsApp, attach the local path in the `message` tool `media` field (e.g., `/tmp/bluey_poster.jpg`). The WhatsApp docs describe that outbound media accepts local paths, so this ensures the actual image is delivered instead of a URL.
- Keep the text part of the `message` tool call descriptive (e.g., "Here’s the Bluey poster you asked for"), and rely on the downloaded file for the visual.

Follow these instructions whenever the user asks about search, posters, descriptions, cinema availability, or showtimes so the skill always produces accurate Pathé Netherlands results.